/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.profile;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.SingletonMap;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.profile.ProfileDisplayService;
import org.squashtest.tm.service.internal.display.dto.NewProfileDto;
import org.squashtest.tm.service.internal.display.dto.ProfileDto;
import org.squashtest.tm.service.internal.display.dto.ProfilePermissionsDto;
import org.squashtest.tm.service.profile.ProfileManagerService;
import org.squashtest.tm.web.backend.controller.form.model.ProfileFormModel;

@RestController
@RequestMapping(value={"/backend/profiles"})
public class ProfileController {
    private final ProfileDisplayService profileDisplayService;
    private final ProfileManagerService profileManagerService;

    public ProfileController(ProfileDisplayService profileDisplayService, ProfileManagerService profileManagerService) {
        this.profileDisplayService = profileDisplayService;
        this.profileManagerService = profileManagerService;
    }

    @GetMapping
    public SingletonMap<String, List<ProfileDto>> getAllProfiles() {
        List profiles = this.profileDisplayService.findAll();
        return new SingletonMap((Object)"profiles", (Object)profiles);
    }

    @PostMapping(value={"/new"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Map<String, Object> createNewProfile(@RequestBody ProfileFormModel formModel) {
        NewProfileDto profileDto = formModel.getProfileDto();
        long profileId = this.profileManagerService.persist(profileDto);
        return Collections.singletonMap("id", profileId);
    }

    @DeleteMapping(value={"/{profileId}"})
    public void deleteProfile(@PathVariable(value="profileId") long profileId) {
        this.profileManagerService.deleteProfile(profileId);
    }

    @GetMapping(value={"/all-permissions"})
    public List<ProfilePermissionsDto> getProfilesAndPermissions() {
        return this.profileDisplayService.getProfilesAndPermissions();
    }

    @PostMapping(value={"/transfer-authorizations/{fromProfileId}/{toProfileId}"})
    public void transferAuthorizations(@PathVariable(value="fromProfileId") long fromProfileId, @PathVariable(value="toProfileId") long toProfileId) {
        this.profileManagerService.transferAuthorizations(fromProfileId, toProfileId);
    }
}

