/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.milestone;

import jakarta.inject.Inject;
import jakarta.validation.Valid;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneRange;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.milestone.MilestoneLabelAlreadyExistsException;
import org.squashtest.tm.exception.milestone.MilestoneRangeNotFoundException;
import org.squashtest.tm.service.display.milestone.MilestoneDisplayService;
import org.squashtest.tm.service.internal.display.dto.MilestoneDto;
import org.squashtest.tm.service.internal.display.dto.MilestonePossibleOwnerDto;
import org.squashtest.tm.service.internal.display.dto.milestone.MilestoneDuplicationModel;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.milestone.MilestoneBindingManagerService;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.user.UserAdministrationService;
import org.squashtest.tm.web.backend.controller.form.model.MilestoneFormModel;

@RestController
@RequestMapping(value={"/backend/milestones"})
public class MilestoneController {
    private static final String LABEL = "label";
    private static final String MILESTONE = "Milestone";
    private final MilestoneDisplayService milestoneDisplayService;
    private final MilestoneManagerService milestoneManager;
    private final PermissionEvaluationService permissionEvaluationService;
    private final ProjectFinder projectFinder;
    private final UserAdministrationService userAdministrationService;
    private final UserAccountService userService;
    private final MilestoneBindingManagerService milestoneBindingManager;

    @Inject
    MilestoneController(MilestoneDisplayService milestoneDisplayService, MilestoneManagerService milestoneManager, PermissionEvaluationService permissionEvaluationService, ProjectFinder projectFinder, UserAdministrationService userAdministrationService, UserAccountService userService, MilestoneBindingManagerService milestoneBindingManager) {
        this.milestoneDisplayService = milestoneDisplayService;
        this.milestoneManager = milestoneManager;
        this.permissionEvaluationService = permissionEvaluationService;
        this.projectFinder = projectFinder;
        this.userAdministrationService = userAdministrationService;
        this.userService = userService;
        this.milestoneBindingManager = milestoneBindingManager;
    }

    @PostMapping
    public GridResponse getAllMilestones(@RequestBody GridRequest request) {
        return this.milestoneDisplayService.findAll(request);
    }

    @DeleteMapping(value={"/{milestoneIds}"})
    public void deleteMilestone(@PathVariable(value="milestoneIds") List<Long> milestoneIds) {
        this.milestoneManager.removeMilestones(milestoneIds);
    }

    @PostMapping(value={"/new"})
    public Map<String, Object> addMilestone(@Valid @RequestBody MilestoneFormModel milestoneFormModel) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Milestone milestone = milestoneFormModel.getMilestone();
        this.setRange(milestone);
        this.setPerimeter(milestone);
        try {
            this.milestoneManager.addMilestone(milestone);
            response.put("id", milestone.getId());
        }
        catch (MilestoneLabelAlreadyExistsException ex) {
            throw new NameAlreadyInUseException(MILESTONE, milestoneFormModel.getLabel(), LABEL, (Exception)((Object)ex));
        }
        return response;
    }

    private void setRange(Milestone milestone) {
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            milestone.setRange(MilestoneRange.GLOBAL);
        } else {
            milestone.setRange(MilestoneRange.RESTRICTED);
        }
    }

    private void setPerimeter(Milestone milestone) {
        if (!this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            List projects = this.projectFinder.findAllICanManage();
            milestone.addProjectsToPerimeter(projects);
        }
    }

    @PostMapping(value={"/{milestoneId}/label"})
    public void changeLabel(@PathVariable long milestoneId, @RequestBody MilestonePatch patch) {
        this.verifyCanEditMilestone(milestoneId);
        try {
            this.milestoneManager.changeLabel(milestoneId, patch.label());
        }
        catch (MilestoneLabelAlreadyExistsException ex) {
            throw new NameAlreadyInUseException(MILESTONE, patch.label(), LABEL, (Exception)((Object)ex));
        }
    }

    @PostMapping(value={"/{milestoneId}/status"})
    public MilestoneDto changeStatus(@PathVariable(value="milestoneId") long milestoneId, @RequestBody MilestonePatch patch) {
        this.verifyCanEditMilestone(milestoneId);
        MilestoneStatus status = MilestoneStatus.valueOf((String)patch.status());
        this.milestoneManager.changeStatus(milestoneId, status);
        if (status.equals((Object)MilestoneStatus.PLANNED)) {
            this.milestoneManager.unbindAllObjects(milestoneId);
        }
        return this.milestoneDisplayService.getMilestoneView(milestoneId);
    }

    @PostMapping(value={"/{milestoneId}/end-date"})
    public MilestoneDto changeEndDate(@PathVariable(value="milestoneId") Long milestoneId, @RequestBody MilestonePatch patch) {
        this.verifyCanEditMilestone(milestoneId);
        this.milestoneManager.changeEndDate(milestoneId.longValue(), patch.endDate());
        return this.milestoneDisplayService.getMilestoneView(milestoneId.longValue());
    }

    @PostMapping(value={"/{milestoneId}/range"})
    public MilestoneDto changeRange(@PathVariable(value="milestoneId") Long milestoneId, @RequestBody MilestonePatch patch) {
        this.milestoneManager.verifyCanEditMilestoneRange();
        this.checkRangeParameter(patch.range());
        if (MilestoneRange.RESTRICTED.name().equals(patch.range()) && this.milestoneManager.isBoundToATemplate(milestoneId.longValue())) {
            this.milestoneBindingManager.unbindTemplateFrom(milestoneId.longValue());
        }
        this.milestoneManager.changeOwner(milestoneId.longValue(), this.userService.findCurrentUser());
        this.milestoneManager.changeRange(milestoneId.longValue(), MilestoneRange.valueOf((String)patch.range()));
        return this.milestoneDisplayService.getMilestoneView(milestoneId.longValue());
    }

    private void checkRangeParameter(String range) {
        try {
            MilestoneRange.valueOf((String)range);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MilestoneRangeNotFoundException();
        }
    }

    @PostMapping(value={"/{milestoneId}/description"})
    public MilestoneDto changeDescription(@PathVariable(value="milestoneId") Long milestoneId, @RequestBody MilestonePatch patch) {
        this.verifyCanEditMilestone(milestoneId);
        this.milestoneManager.changeDescription(milestoneId.longValue(), patch.description());
        return this.milestoneDisplayService.getMilestoneView(milestoneId.longValue());
    }

    @PostMapping(value={"/{milestoneId}/owner"})
    public MilestoneDto changeOwner(@PathVariable(value="milestoneId") Long milestoneId, @RequestBody MilestonePatch patch) {
        this.verifyCanEditMilestone(milestoneId);
        User newOwner = this.userAdministrationService.findByLogin(patch.ownerLogin());
        this.milestoneManager.changeOwner(milestoneId.longValue(), newOwner);
        return this.milestoneDisplayService.getMilestoneView(milestoneId.longValue());
    }

    @GetMapping(value={"/possible-owners"})
    public List<MilestonePossibleOwnerDto> findPossibleOwners() {
        return this.userAdministrationService.findAllAdminOrManager().stream().sorted((o1, o2) -> o1.login().compareToIgnoreCase(o2.login())).toList();
    }

    @PostMapping(value={"/{motherId}/clone"})
    public Map<String, Long> cloneMilestone(@PathVariable(value="motherId") long motherId, @RequestBody MilestoneDuplicationModel model) {
        try {
            long cloneMilestoneId = this.milestoneManager.cloneMilestone(motherId, model);
            return Collections.singletonMap("id", cloneMilestoneId);
        }
        catch (MilestoneLabelAlreadyExistsException ex) {
            throw new NameAlreadyInUseException(MILESTONE, model.label(), LABEL, (Exception)((Object)ex));
        }
    }

    @PostMapping(value={"/{sourceId}/synchronize/{targetId}"})
    public void synchronizeMilestone(@PathVariable(value="sourceId") long sourceId, @PathVariable(value="targetId") long targetId, @RequestBody SynchronizationParameters parameters) {
        this.milestoneManager.synchronize(sourceId, targetId, parameters.extendPerimeter(), parameters.union());
    }

    private void verifyCanEditMilestone(Long milestoneId) {
        this.milestoneManager.verifyCanEditMilestone(milestoneId.longValue());
    }

    public record MilestonePatch(String label, String range, Date endDate, String status, String description, String ownerLogin) {
    }

    public record SynchronizationParameters(boolean extendPerimeter, boolean union) {
    }
}

