/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.milestone;

import jakarta.inject.Inject;
import jakarta.validation.Valid;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneRange;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.milestone.MilestoneLabelAlreadyExistsException;
import org.squashtest.tm.service.display.milestone.MilestoneDisplayService;
import org.squashtest.tm.service.internal.display.dto.BindableProjectToMilestoneDto;
import org.squashtest.tm.service.internal.display.dto.MilestoneAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.MilestoneDto;
import org.squashtest.tm.service.internal.display.dto.MilestoneProjectViewDto;
import org.squashtest.tm.service.internal.display.dto.ProjectInfoForMilestoneAdminViewDto;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.milestone.CustomMilestoneManager;
import org.squashtest.tm.service.milestone.MilestoneBindingManagerService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.backend.controller.form.model.MilestoneFormModel;

@RestController
@RequestMapping(value={"/backend/milestone-binding"})
public class MilestoneBindingController {
    private final CustomMilestoneManager customMilestoneManager;
    private final MilestoneBindingManagerService milestoneBindingManagerService;
    private final PermissionEvaluationService permissionEvaluationService;
    private final ProjectFinder projectFinder;
    private final MilestoneDisplayService milestoneDisplayService;

    @Inject
    MilestoneBindingController(CustomMilestoneManager customMilestoneManager, MilestoneBindingManagerService milestoneBindingManagerService, PermissionEvaluationService permissionEvaluationService, ProjectFinder projectFinder, MilestoneDisplayService milestoneDisplayService) {
        this.customMilestoneManager = customMilestoneManager;
        this.milestoneBindingManagerService = milestoneBindingManagerService;
        this.permissionEvaluationService = permissionEvaluationService;
        this.projectFinder = projectFinder;
        this.milestoneDisplayService = milestoneDisplayService;
    }

    @PostMapping(value={"/project/{projectId}/bind-milestones/{milestoneIds}"})
    public void bindMilestonesToProject(@PathVariable long projectId, @PathVariable List<Long> milestoneIds) {
        this.milestoneBindingManagerService.bindMilestonesToProject(milestoneIds, projectId);
    }

    @DeleteMapping(value={"/project/{projectId}/unbind-milestones/{milestoneIds}"})
    public void unbindMilestonesFromProject(@PathVariable long projectId, @PathVariable List<Long> milestoneIds) {
        this.milestoneBindingManagerService.unbindMilestonesFromProject(milestoneIds, projectId);
    }

    @PostMapping(value={"/{milestoneId}/bind-projects/{projectIds}"})
    public Map<String, List<ProjectInfoForMilestoneAdminViewDto>> bindProjectsToMilestone(@PathVariable long milestoneId, @PathVariable List<Long> projectIds) {
        this.milestoneBindingManagerService.bindProjectsToMilestone(projectIds, milestoneId);
        MilestoneAdminViewDto milestone = this.milestoneDisplayService.getMilestoneView(milestoneId);
        return Collections.singletonMap("boundProjectsInformation", milestone.getBoundProjectsInformation());
    }

    @DeleteMapping(value={"/{milestoneId}/unbind-projects/{projectIds}"})
    public void unbindProjectsFromMilestone(@PathVariable long milestoneId, @PathVariable List<Long> projectIds) {
        this.milestoneBindingManagerService.unbindProjectsFromMilestone(projectIds, milestoneId);
    }

    @DeleteMapping(value={"/{milestoneId}/unbind-projects-and-keep-in-perimeter/{projectIds}"})
    public void unbindProjectFromMilestoneKeepInPerimeter(@PathVariable(value="milestoneId") long milestoneId, @PathVariable(value="projectIds") List<Long> projectIds) {
        this.milestoneBindingManagerService.unbindProjectsFromMilestoneKeepInPerimeter(projectIds, milestoneId);
    }

    @GetMapping(value={"/{milestoneId}/bindable-projects"})
    public Map<String, List<BindableProjectToMilestoneDto>> getBindableProjectsForMilestone(@PathVariable long milestoneId) {
        List bindableProjects = this.milestoneBindingManagerService.getAllBindableProjectForMilestone(milestoneId);
        return Collections.singletonMap("bindableProjects", bindableProjects);
    }

    @PostMapping(value={"/project/{projectId}/create-milestone-and-bind-to-project"})
    public Map<String, Object> createAndBindMilestoneToProject(@PathVariable long projectId, @Valid @RequestBody MilestoneFormModel milestoneFormModel) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Milestone milestone = this.createMilestone(milestoneFormModel);
        MilestoneProjectViewDto milestoneProjectViewDto = this.prepareServerResponseAfterCreatingMilestone(milestone);
        milestoneProjectViewDto.setMilestoneBoundToOneObjectOfProject(false);
        response.put("milestone", milestoneProjectViewDto);
        this.milestoneBindingManagerService.bindNewMilestonesToProject(Collections.singletonList(milestone.getId()), projectId);
        return response;
    }

    @PostMapping(value={"/project/{projectId}/create-milestone-and-bind-to-project-and-objects"})
    public Map<String, Object> createAndBindMilestoneToProjectAndObjects(@PathVariable long projectId, @Valid @RequestBody MilestoneFormModel milestoneFormModel) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Milestone milestone = this.createMilestone(milestoneFormModel);
        MilestoneProjectViewDto milestoneProjectViewDto = this.prepareServerResponseAfterCreatingMilestone(milestone);
        milestoneProjectViewDto.setMilestoneBoundToOneObjectOfProject(true);
        response.put("milestone", milestoneProjectViewDto);
        this.milestoneBindingManagerService.bindNewMilestonesToProjectAndBindObject(projectId, Collections.singletonList(milestone.getId()));
        return response;
    }

    private Milestone createMilestone(MilestoneFormModel milestoneFormModel) {
        Milestone milestone = milestoneFormModel.getMilestone();
        this.setRange(milestone);
        this.setPerimeter(milestone);
        try {
            this.customMilestoneManager.addMilestone(milestone);
        }
        catch (MilestoneLabelAlreadyExistsException ex) {
            throw new NameAlreadyInUseException("Milestone", milestoneFormModel.getLabel(), "label", (Exception)((Object)ex));
        }
        return milestone;
    }

    private MilestoneProjectViewDto prepareServerResponseAfterCreatingMilestone(Milestone milestone) {
        MilestoneProjectViewDto response = new MilestoneProjectViewDto();
        MilestoneDto milestoneDto = new MilestoneDto();
        milestoneDto.setId(milestone.getId());
        milestoneDto.setLabel(milestone.getLabel());
        String sanitizedDescription = HTMLCleanupUtils.htmlToTrimmedText((String)milestone.getDescription());
        milestoneDto.setDescription(sanitizedDescription);
        milestoneDto.setEndDate(milestone.getEndDate());
        milestoneDto.setOwnerFirstName(milestone.getOwner().getFirstName());
        milestoneDto.setOwnerLastName(milestone.getOwner().getLastName());
        milestoneDto.setOwnerLogin(milestone.getOwner().getLogin());
        milestoneDto.setStatus(milestone.getStatus().name());
        milestoneDto.setRange(milestone.getRange().name());
        response.setMilestone(milestoneDto);
        return response;
    }

    private void setRange(Milestone milestone) {
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            milestone.setRange(MilestoneRange.GLOBAL);
        } else {
            milestone.setRange(MilestoneRange.RESTRICTED);
        }
    }

    private void setPerimeter(Milestone milestone) {
        if (!this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            List projects = this.projectFinder.findAllICanManage();
            milestone.addProjectsToPerimeter(projects);
        }
    }
}

