/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.infolist;

import jakarta.inject.Inject;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.infolist.InfoListDisplayService;
import org.squashtest.tm.service.infolist.InfoListItemManagerService;
import org.squashtest.tm.service.infolist.InfoListManagerService;
import org.squashtest.tm.service.internal.display.dto.InfoListAdminViewDto;

@RestController
@RequestMapping(value={"/backend/info-list-items"})
public class InfoListItemController {
    InfoListItemManagerService infoListItemManagerService;
    InfoListManagerService infoListManagerService;
    InfoListDisplayService infoListDisplayService;

    @Inject
    InfoListItemController(InfoListItemManagerService infoListItemManagerService, InfoListManagerService infoListManagerService, InfoListDisplayService infoListDisplayService) {
        this.infoListItemManagerService = infoListItemManagerService;
        this.infoListManagerService = infoListManagerService;
        this.infoListDisplayService = infoListDisplayService;
    }

    @PostMapping(value={"/{infoListItemId}/label"})
    public void changeLabel(@PathVariable long infoListItemId, @RequestBody InfoListItemPatch patch) {
        this.infoListItemManagerService.changeLabel(infoListItemId, patch.getLabel());
    }

    @PostMapping(value={"/{infoListItemId}/code"})
    public void changeCode(@PathVariable long infoListItemId, @RequestBody InfoListItemPatch patch) {
        this.infoListItemManagerService.changeCode(infoListItemId, patch.getCode());
    }

    @PostMapping(value={"/{infoListItemId}/colour"})
    public void changeColour(@PathVariable long infoListItemId, @RequestBody InfoListItemPatch patch) {
        this.infoListItemManagerService.changeColour(infoListItemId, patch.getColour());
    }

    @PostMapping(value={"/{infoListItemId}/default"})
    public void setDefault(@PathVariable long infoListItemId) {
        this.infoListItemManagerService.changeDefault(infoListItemId);
    }

    @PostMapping(value={"/{infoListItemId}/icon-name"})
    public void changeIcon(@PathVariable long infoListItemId, @RequestBody InfoListItemPatch patch) {
        this.infoListItemManagerService.changeIcon(infoListItemId, patch.getIconName());
    }

    @DeleteMapping(value={"/{infoListId}/items/{infoListItemIds}"})
    public void deleteInfoListItem(@PathVariable long infoListId, @PathVariable List<Long> infoListItemIds) {
        this.infoListItemManagerService.removeInfoListItems(infoListItemIds, infoListId);
    }

    @PostMapping(value={"/{infoListId}/items/positions"})
    public InfoListAdminViewDto changeOptionsPositions(@PathVariable long infoListId, @RequestBody ReorderOptionsRequestBody requestBody) {
        this.infoListManagerService.changeItemsPositions(infoListId, requestBody.getPosition().intValue(), requestBody.getInfoListItemIds());
        return this.infoListDisplayService.getInfoListView(infoListId);
    }

    public static class InfoListItemPatch {
        private String label;
        private String code;
        private String colour;
        private String iconName;

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getColour() {
            return this.colour;
        }

        public void setColour(String colour) {
            this.colour = colour;
        }

        public String getIconName() {
            return this.iconName;
        }

        public void setIconName(String iconName) {
            this.iconName = iconName;
        }
    }

    static class ReorderOptionsRequestBody {
        private List<Long> infoListItemIds;
        private Integer position;

        ReorderOptionsRequestBody() {
        }

        public Integer getPosition() {
            return this.position;
        }

        public void setPosition(Integer position) {
            this.position = position;
        }

        public List<Long> getInfoListItemIds() {
            return this.infoListItemIds;
        }

        public void setInfoListItemIds(List<Long> infoListItemIds) {
            this.infoListItemIds = infoListItemIds;
        }
    }
}

