/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.export.grid;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.squashtest.tm.web.backend.controller.export.grid.AbstractGridExporter;
import org.squashtest.tm.web.backend.controller.export.grid.GridExportModel;

public class XlsGridExporter
extends AbstractGridExporter {
    public XlsGridExporter(GridExportModel gridExportModel) {
        super(gridExportModel);
    }

    @Override
    public File export() throws IOException {
        this.printHeaders();
        this.printRows();
        this.formatColumns();
        File exportedFile = this.flushToTemporaryFile();
        this.clean();
        return exportedFile;
    }

    private void formatColumns() {
        this.sheet.trackAllColumnsForAutoSizing();
        int i = 0;
        while (i < this.gridExportModel.getExportedColumns().size()) {
            this.sheet.autoSizeColumn(i);
            ++i;
        }
    }

    private void clean() throws IOException {
        this.workbook.close();
    }

    private File flushToTemporaryFile() throws IOException {
        File temp = File.createTempFile("grid_export_", ".xls");
        temp.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(temp);
        this.workbook.write((OutputStream)fos);
        fos.close();
        return temp;
    }
}

