/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.execution;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.campaign.TestPlanExecutionProcessingService;
import org.squashtest.tm.service.internal.display.dto.execution.TestPlanResume;
import org.squashtest.tm.web.backend.controller.execution.FiltersContainer;
import org.squashtest.tm.web.backend.controller.form.model.IdList;

@RestController
@RequestMapping(value={"/backend/iteration/{iterationId}/test-plan"})
public class IterationExecutionRunnerController {
    private final TestPlanExecutionProcessingService<TestPlanResume.IterationTestPlanResume> iterationExecutionProcessingService;

    public IterationExecutionRunnerController(TestPlanExecutionProcessingService<TestPlanResume.IterationTestPlanResume> iterationExecutionProcessingService) {
        this.iterationExecutionProcessingService = iterationExecutionProcessingService;
    }

    @PostMapping(value={"/resume"})
    public TestPlanResume.IterationTestPlanResume resumeIteration(@PathVariable long iterationId) {
        return (TestPlanResume.IterationTestPlanResume)this.iterationExecutionProcessingService.startResume(iterationId);
    }

    @PostMapping(value={"/resume-filtered-selection"})
    public TestPlanResume resumeIterationWithFilter(@PathVariable long iterationId, @RequestBody FiltersContainer filtersContainer) {
        return this.iterationExecutionProcessingService.resumeWithFilteredTestPlan(iterationId, filtersContainer.getFilterValues());
    }

    @PostMapping(value={"/relaunch"})
    public TestPlanResume.IterationTestPlanResume relaunchIteration(@PathVariable long iterationId) {
        return (TestPlanResume.IterationTestPlanResume)this.iterationExecutionProcessingService.relaunch(iterationId);
    }

    @PostMapping(value={"/relaunch-filtered-selection"})
    public TestPlanResume relaunchIterationWithFilter(@PathVariable long iterationId, @RequestBody FiltersContainer filtersContainer) {
        return this.iterationExecutionProcessingService.relaunchFilteredTestPlan(iterationId, filtersContainer.getFilterValues());
    }

    @RequestMapping(value={"/{testPlanItemId}/next-execution"})
    public TestPlanResume.IterationTestPlanResume moveToNextTestCase(@PathVariable(value="testPlanItemId") long testPlanItemId, @PathVariable(value="iterationId") long iterationId) {
        return (TestPlanResume.IterationTestPlanResume)this.iterationExecutionProcessingService.startResumeNextExecution(iterationId, testPlanItemId);
    }

    @RequestMapping(value={"/{testPlanItemId}/next-execution-filtered-selection"})
    public TestPlanResume moveToNextTestCaseOfFilteredTestPlan(@PathVariable(value="testPlanItemId") long testPlanItemId, @PathVariable(value="iterationId") long iterationId, @RequestBody IdList partialTestPlan) {
        return this.iterationExecutionProcessingService.resumeNextExecutionOfFilteredTestPlan(iterationId, testPlanItemId, partialTestPlan.getIds());
    }
}

