/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.execution;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.execution.ExploratoryExecutionService;

@RestController
@RequestMapping(value={"/backend/exploratory-execution/{executionId}"})
public class ExploratoryExecutionController {
    private final ExploratoryExecutionService exploratoryExecutionService;

    public ExploratoryExecutionController(ExploratoryExecutionService exploratoryExecutionService) {
        this.exploratoryExecutionService = exploratoryExecutionService;
    }

    @PostMapping(value={"run"})
    public void runExploratoryExecution(@PathVariable(value="executionId") Long executionId) {
        this.exploratoryExecutionService.startOrResumeExploratoryExecution(executionId.longValue(), UserContextHolder.getUsername());
    }

    @PostMapping(value={"pause"})
    public void pauseExploratoryExecution(@PathVariable(value="executionId") Long executionId) {
        this.exploratoryExecutionService.pauseExploratoryExecution(executionId.longValue(), UserContextHolder.getUsername());
    }

    @PostMapping(value={"stop"})
    public void stopExploratoryExecution(@PathVariable(value="executionId") Long executionId) {
        this.exploratoryExecutionService.stopExploratoryExecution(executionId.longValue(), UserContextHolder.getUsername());
    }

    @PostMapping(value={"assign-user-to-exploratory-execution"})
    public void assignUser(@PathVariable(value="executionId") Long executionId, @RequestBody ExploratorySessionPatch exploratorySessionPatch) {
        this.exploratoryExecutionService.assignUser(executionId, exploratorySessionPatch.userId);
    }

    @PostMapping(value={"update-task-division"})
    public void updateTaskDivision(@PathVariable(value="executionId") Long executionId, @RequestBody ExploratorySessionPatch exploratorySessionPatch) {
        this.exploratoryExecutionService.updateTaskDivision(executionId, exploratorySessionPatch.taskDivision);
    }

    @PostMapping(value={"update-review-status"})
    public void updateReviewStatus(@PathVariable(value="executionId") Long executionId, @RequestBody ExploratorySessionPatch exploratorySessionPatch) {
        this.exploratoryExecutionService.updateReviewStatus(executionId, exploratorySessionPatch.reviewed);
    }

    @GetMapping(value={"is-execution-running"})
    public boolean isExecutionRunning(@PathVariable(value="executionId") Long executionId) {
        return this.exploratoryExecutionService.isExecutionRunning(executionId);
    }

    public record ExploratorySessionPatch(Long userId, String taskDivision, boolean reviewed) {
    }
}

