/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.customfield;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.service.customfield.CustomFieldBindingModificationService;
import org.squashtest.tm.service.display.custom.field.CustomFieldDisplayService;
import org.squashtest.tm.service.internal.display.dto.CufBindingDto;
import org.squashtest.tm.service.internal.dto.CustomFieldBindingModel;

@RestController
@RequestMapping(value={"/backend/custom-field-binding"})
public class CustomFieldBindingController {
    private final CustomFieldBindingModificationService customFieldBindingModificationService;
    private final CustomFieldDisplayService customFieldDisplayService;

    @Inject
    public CustomFieldBindingController(CustomFieldBindingModificationService customFieldBindingModificationService, CustomFieldDisplayService customFieldDisplayService) {
        this.customFieldBindingModificationService = customFieldBindingModificationService;
        this.customFieldDisplayService = customFieldDisplayService;
    }

    @PostMapping(value={"/project/{projectId}/bind-custom-fields"})
    public Map<BindableEntity, Set<CufBindingDto>> bindCustomFieldsToProject(@PathVariable long projectId, @RequestBody Map<String, CustomFieldBindingModel[]> requestBody) {
        this.customFieldBindingModificationService.createNewBindings(requestBody.get("customFieldBindings"));
        return this.customFieldDisplayService.findAllCustomFieldBindings(Long.valueOf(projectId));
    }

    @DeleteMapping(value={"/project/unbind-custom-fields/{customFieldBindingIds}"})
    public void unbindCustomFieldsFromProject(@PathVariable List<Long> customFieldBindingIds) {
        this.customFieldBindingModificationService.removeCustomFieldBindings(customFieldBindingIds);
    }
}

