/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.connection.logs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.connection.log.ConnectionLogDisplayService;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.GridSort;

@RestController
@RequestMapping(value={"/backend/users/connection-logs"})
public class ConnectionLogsController {
    private final ConnectionLogDisplayService connectionLogDisplayService;

    ConnectionLogsController(ConnectionLogDisplayService connectionLogDisplayService) {
        this.connectionLogDisplayService = connectionLogDisplayService;
    }

    @PostMapping
    public GridResponse getAllConnectionLogs(@RequestBody GridRequest request) {
        return this.connectionLogDisplayService.findAll(request);
    }

    @PostMapping(value={"/export"})
    public Map<String, String> exportConnectionLog(@RequestBody ExportRequestBody requestBody) {
        GridRequest gridRequest = this.prepareNonPaginatedGridRequest(requestBody.getFilterValues());
        GridResponse gridResponse = this.connectionLogDisplayService.findAll(gridRequest);
        String export = ExportFileBuilder.exportAsCSV(gridResponse);
        return Collections.singletonMap("export", export);
    }

    private GridRequest prepareNonPaginatedGridRequest(List<GridFilterValue> filterValues) {
        GridRequest gridRequest = new GridRequest();
        gridRequest.setFilterValues(filterValues);
        GridSort gridSort = new GridSort("connectionDate", GridSort.SortDirection.ASC);
        gridRequest.setSort(Collections.singletonList(gridSort));
        return gridRequest.toNonPaginatedRequest();
    }

    private static class ExportFileBuilder {
        public static final String ID_KEY = "attemptId";
        public static final String LOGIN_KEY = "login";
        public static final String CONNECTION_DATE_KEY = "connectionDate";
        public static final String SUCCESS_KEY = "success";
        public static final String ID_COLUMN = "Id";
        public static final String LOGIN_COLUMN = "Login";
        public static final String CONNECTION_DATE_COLUMN = "Connection Date";
        public static final String SUCCESS_COLUMN = "Success";
        private static final String NEW_LINE = "\n";

        private ExportFileBuilder() {
        }

        static String exportAsCSV(GridResponse gridResponse) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ExportFileBuilder.buildHeaders());
            gridResponse.getDataRows().forEach(dataRow -> {
                StringBuilder stringBuilder2 = stringBuilder.append(ExportFileBuilder.buildLine(dataRow.getData().getOrDefault(ID_KEY, "-").toString(), dataRow.getData().getOrDefault(LOGIN_KEY, "-").toString(), dataRow.getData().getOrDefault(CONNECTION_DATE_KEY, "-").toString(), dataRow.getData().getOrDefault(SUCCESS_KEY, "-").toString()));
            });
            return stringBuilder.toString();
        }

        private static String buildHeaders() {
            return ExportFileBuilder.buildLine(ID_COLUMN, LOGIN_COLUMN, CONNECTION_DATE_COLUMN, SUCCESS_COLUMN);
        }

        private static String buildLine(String ... values) {
            return String.join((CharSequence)";", values) + NEW_LINE;
        }
    }

    private static class ExportRequestBody {
        private List<GridFilterValue> filterValues;

        private ExportRequestBody() {
        }

        public List<GridFilterValue> getFilterValues() {
            return this.filterValues;
        }

        public void setFilterValues(List<GridFilterValue> filterValues) {
            this.filterValues = filterValues;
        }
    }
}

