/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.config;

import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.feature.FeatureManager;

@RestController
@RequestMapping(value={"/backend/features"})
public class SquashFeatureController {
    private static final String ENABLED = "enabled";
    private final Object monitor = new Object();
    @Inject
    private FeatureManager featureManager;
    @Inject
    private ServletContext applicationScope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/milestones"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setMilestonesFeature(@RequestBody SetMilestoneFeatureRequestBody requestBody) {
        Boolean enabled = requestBody.getEnabled();
        Object object = this.monitor;
        synchronized (object) {
            Object prevState = this.applicationScope.getAttribute("milestoneFeatureEnabled");
            this.applicationScope.setAttribute("milestoneFeatureEnabled", (Object)false);
            try {
                this.featureManager.setEnabled(FeatureManager.Feature.MILESTONE, enabled.booleanValue());
                this.applicationScope.setAttribute("milestoneFeatureEnabled", (Object)enabled);
            }
            catch (RuntimeException ex) {
                this.applicationScope.setAttribute("milestoneFeatureEnabled", prevState);
                throw ex;
            }
        }
    }

    @PostMapping(value={"/case-insensitive-login"}, params={"enabled"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setCaseInsensitiveLoginFeature(@RequestParam(value="enabled") boolean enabled) {
        this.featureManager.setEnabled(FeatureManager.Feature.CASE_INSENSITIVE_LOGIN, enabled);
    }

    @PostMapping(value={"/case-insensitive-actions"}, params={"enabled"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setCaseInsensitiveActionsFeature(@RequestParam(value="enabled") boolean enabled) {
        this.featureManager.setEnabled(FeatureManager.Feature.CASE_INSENSITIVE_ACTIONS, enabled);
    }

    @PostMapping(value={"/stack-trace"}, params={"enabled"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setStackTraceFeature(@RequestParam(value="enabled") boolean enabled) {
        this.featureManager.setEnabled(FeatureManager.Feature.STACK_TRACE, enabled);
    }

    @PostMapping(value={"/unsafe-attachment-preview"}, params={"enabled"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setUnsafeAttachmentPreviewFeature(@RequestParam(value="enabled") boolean enabled) {
        this.featureManager.setEnabled(FeatureManager.Feature.UNSAFE_ATTACHMENT_PREVIEW, enabled);
    }

    @PostMapping(value={"/autoconnect-on-connection"}, params={"enabled"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setAutoconnectOnConnectionFeature(@RequestParam(value="enabled") boolean enabled) {
        this.featureManager.setEnabled(FeatureManager.Feature.AUTOCONNECT_ON_CONNECTION, enabled);
    }

    @PostMapping(value={"/search-activation"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setSearchActivationFeature(@RequestBody SetMilestoneFeatureRequestBody requestBody) {
        Boolean enabled = requestBody.getEnabled();
        this.featureManager.setEnabled(FeatureManager.Feature.SEARCH_ACTIVATION, enabled.booleanValue());
    }

    public static class SetMilestoneFeatureRequestBody {
        Boolean enabled;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }
    }
}

