/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.campaign.SprintExecutionCreationService;
import org.squashtest.tm.service.campaign.SprintTestPlanItemManagerService;
import org.squashtest.tm.service.display.campaign.TestPlanItemDisplayService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.web.backend.controller.campaign.IterationTestPlanManagerController;

@RestController
@RequestMapping(value={"backend/test-plan-item"})
public class TestPlanItemController {
    private final IterationTestPlanManagerService iterationTestPlanManagerService;
    private final CampaignTestPlanManagerService campaignTestPlanManagerService;
    private final SprintTestPlanItemManagerService sprintTestPlanItemManagerService;
    private final SprintExecutionCreationService sprintExecutionCreationService;
    private final TestPlanItemDisplayService testPlanItemDisplayService;

    public TestPlanItemController(IterationTestPlanManagerService iterationTestPlanManagerService, CampaignTestPlanManagerService campaignTestPlanManagerService, SprintTestPlanItemManagerService sprintTestPlanItemManagerService, SprintExecutionCreationService sprintExecutionCreationService, TestPlanItemDisplayService testPlanItemDisplayService) {
        this.iterationTestPlanManagerService = iterationTestPlanManagerService;
        this.campaignTestPlanManagerService = campaignTestPlanManagerService;
        this.sprintTestPlanItemManagerService = sprintTestPlanItemManagerService;
        this.sprintExecutionCreationService = sprintExecutionCreationService;
        this.testPlanItemDisplayService = testPlanItemDisplayService;
    }

    @PostMapping(value={"iteration/{testPlanItemId}/dataset"})
    public Long setDatasetToIterationTestPlanItem(@PathVariable long testPlanItemId, @RequestBody DatasetIdRecord patch) {
        this.iterationTestPlanManagerService.changeDataset(testPlanItemId, patch.datasetId());
        return patch.datasetId();
    }

    @PostMapping(value={"test-suite/{testPlanItemId}/dataset"})
    public Long setDatasetToTestSuiteTestPlanItem(@PathVariable long testPlanItemId, @RequestBody DatasetIdRecord patch) {
        this.iterationTestPlanManagerService.changeDataset(testPlanItemId, patch.datasetId());
        return patch.datasetId();
    }

    @PostMapping(value={"campaign/{testPlanItemId}/dataset"})
    public Long setDatasetToCampaignTestPlanItem(@PathVariable long testPlanItemId, @RequestBody DatasetIdRecord patch) {
        this.campaignTestPlanManagerService.changeDataset(testPlanItemId, patch.datasetId());
        return patch.datasetId();
    }

    @PostMapping(value={"sprint-req-version/{testPlanItemId}/dataset"})
    public Long setDatasetToSprintRequirementTestPlanItem(@PathVariable long testPlanItemId, @RequestBody DatasetIdRecord patch) {
        this.sprintTestPlanItemManagerService.changeDataset(testPlanItemId, patch.datasetId());
        return patch.datasetId();
    }

    @PostMapping(value={"{testPlanItemId}/new-manual-execution"})
    public CreateExecutionResponse createExecution(@PathVariable long testPlanItemId) {
        Execution newExecution = this.sprintExecutionCreationService.createExecution(testPlanItemId);
        return new CreateExecutionResponse(newExecution.getId());
    }

    @PostMapping(value={"{testPlanItemId}/executions"})
    public GridResponse getExecutions(@PathVariable long testPlanItemId, @RequestBody GridRequest gridRequest) {
        return this.testPlanItemDisplayService.getTestPlanItemExecutions(testPlanItemId, gridRequest);
    }

    @PostMapping(value={"/{testPlanItemsIds}/assign-user"})
    public Long assignUserToIterationTestPlanItem(@PathVariable List<Long> testPlanItemsIds, @RequestBody AssigneeRecord patch) {
        this.iterationTestPlanManagerService.assignUserToTestPlanItems(testPlanItemsIds, patch.assignee.longValue());
        return patch.assignee();
    }

    @PostMapping(value={"/{testPlanItemsId}/assign-user-to-sprint-req-version"})
    public Long assignUserToSprintReqVersionTestPlanItem(@PathVariable Long testPlanItemsId, @RequestBody AssigneeRecord patch) {
        this.sprintTestPlanItemManagerService.assignUserToTestPlanItem(testPlanItemsId, patch.assignee().longValue());
        return patch.assignee();
    }

    @PostMapping(value={"/{testPlanItemsIds}/execution-status"})
    public void updateIterationTestPlanItemsStatus(@PathVariable List<Long> testPlanItemsIds, @RequestBody IterationTestPlanManagerController.IterationTestPlanItemPatch patch) {
        this.iterationTestPlanManagerService.forceExecutionStatus(testPlanItemsIds, patch.getExecutionStatus());
    }

    @PostMapping(value={"/{testPlanItemIds}/status"})
    public void updateTestPlanItemsStatus(@PathVariable List<Long> testPlanItemIds, @RequestBody ExecutionStatusRecord requestBody) {
        this.sprintTestPlanItemManagerService.applyFastPass(testPlanItemIds, requestBody.executionStatus());
    }

    @PostMapping(value={"/{testPlanItemsIds}/assign-user-to-ctpi"})
    public Long assignUserToCampaignTestPlanItem(@PathVariable List<Long> testPlanItemsIds, @RequestBody AssigneeRecord patch) {
        this.campaignTestPlanManagerService.assignUserToTestPlanItems(testPlanItemsIds, patch.assignee);
        return patch.assignee;
    }

    @DeleteMapping(value={"/{testPlanItemId}/execution/{executionIds}"})
    public void deleteExecutions(@PathVariable long testPlanItemId, @PathVariable List<Long> executionIds) {
        this.sprintTestPlanItemManagerService.deleteExecutionsAndRemoveFromTestPlanItem(executionIds, testPlanItemId);
    }

    public record AssigneeRecord(Long assignee) {
    }

    public record CreateExecutionResponse(Long executionId) {
    }

    public record DatasetIdRecord(Long datasetId) {
    }

    public record ExecutionStatusRecord(String executionStatus) {
    }
}

