/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.List;
import java.util.Locale;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.NodeReferences;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.campaign.CampaignDisplayService;
import org.squashtest.tm.service.internal.display.dto.campaign.CampaignMultiSelectionDto;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportDashboardDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.statistics.campaign.StatisticsBundle;
import org.squashtest.tm.web.backend.controller.form.model.NodeList;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"/backend/campaign-workspace-multi-view"})
public class CampaignMultiViewController {
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;
    private final CampaignDisplayService campaignDisplayService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    private final CampaignLibraryNavigationService campaignLibraryNavigationService;

    public CampaignMultiViewController(CampaignDisplayService campaignDisplayService, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider, CampaignLibraryNavigationService campaignLibraryNavigationService) {
        this.campaignDisplayService = campaignDisplayService;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.builderProvider = builderProvider;
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
    }

    @PostMapping
    public CampaignMultiSelectionDto getCampaignMultiView(@RequestBody CampaignMultiViewStatisticsPatch patch, Locale locale) {
        NodeReferences nodeReferences = patch.references.asNodeReferences();
        CampaignMultiSelectionDto multiSelectionDto = new CampaignMultiSelectionDto();
        if (this.campaignDisplayService.isMultiSelectionScopeValid(nodeReferences)) {
            multiSelectionDto = this.campaignDisplayService.getCampaignMultiView(nodeReferences);
            multiSelectionDto.setLastExecutionScope(patch.lastExecutionScope);
            List<String> references = patch.references.getReferences();
            List<EntityReference> entityReferences = references.stream().map(EntityReference::fromNodeId).toList();
            if (multiSelectionDto.isShouldShowFavoriteDashboard() && multiSelectionDto.isCanShowFavoriteDashboard()) {
                CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(multiSelectionDto.getFavoriteDashboardId());
                CustomReportDashboardDto dto = new CustomReportDashboardDto(Workspace.CAMPAIGN, entityReferences, false, false, patch.lastExecutionScope);
                JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(multiSelectionDto.getFavoriteDashboardId(), dashboard, locale, dto);
                multiSelectionDto.setDashboard(jsonDashboard);
            } else if (!multiSelectionDto.isShouldShowFavoriteDashboard()) {
                StatisticsBundle bundle = this.campaignLibraryNavigationService.compileStatisticsFromSelection(nodeReferences, entityReferences, patch.lastExecutionScope);
                multiSelectionDto.setStatistics(bundle);
            }
        }
        return multiSelectionDto;
    }

    public record CampaignMultiViewStatisticsPatch(boolean lastExecutionScope, NodeList references) {
    }
}

