/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.bugtracker;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.csp.core.bugtracker.spi.DefaultOAuth2FormValues;
import org.squashtest.tm.service.display.bugtracker.BugTrackerDisplayService;
import org.squashtest.tm.service.internal.display.dto.BugTrackerViewDto;
import org.squashtest.tm.service.internal.servers.OAuth2ConsumerService;

@RestController
@RequestMapping(value={"/backend/bugtracker-view"})
public class BugTrackerViewController {
    private final BugTrackerDisplayService bugTrackerDisplayService;
    private final OAuth2ConsumerService oAuth2ConsumerService;

    BugTrackerViewController(BugTrackerDisplayService bugTrackerDisplayService, OAuth2ConsumerService oAuth2ConsumerService) {
        this.bugTrackerDisplayService = bugTrackerDisplayService;
        this.oAuth2ConsumerService = oAuth2ConsumerService;
    }

    @GetMapping(value={"/{bugTrackerId}"})
    BugTrackerViewDto getBugTrackerView(@PathVariable Long bugTrackerId) {
        return this.bugTrackerDisplayService.getBugTrackerView(bugTrackerId);
    }

    @GetMapping(value={"/{bugTrackerId}/oauth2/default-form-values"})
    public DefaultOAuth2FormValues askOauth2Token(@PathVariable(value="bugTrackerId") long bugTrackerId) {
        return this.oAuth2ConsumerService.getDefaultOAuth2FormValue(Long.valueOf(bugTrackerId));
    }
}

