/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.bugtracker;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

@Component
public final class BugTrackerControllerHelper {
    private static final String INSERT_NEW_LINES = "\n\n\n";

    private BugTrackerControllerHelper() {
    }

    public static String buildExecutionUrlFromRequest(HttpServletRequest request, Execution execution) {
        return BugTrackerControllerHelper.buildExecutionUrlWithSquashPublicUrl(BugTrackerControllerHelper.extractBaseUrl(request), execution);
    }

    public static String extractBaseUrl(HttpServletRequest request) {
        String requestUrl = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        return HTMLCleanupUtils.cleanHtml((String)requestUrl);
    }

    public static String buildExecutionUrlWithSquashPublicUrl(String squashPublicUrl, Execution execution) {
        String requestUrl = squashPublicUrl + "/execution/" + String.valueOf(execution.getId());
        return HTMLCleanupUtils.cleanHtml((String)requestUrl);
    }

    @Deprecated
    public static String getAdditionalInformation(ExecutionStep buggedStep, Locale locale, MessageSource messageSource) {
        Execution execution = buggedStep.getExecution();
        TestCaseKind testCaseKind = TestCaseKind.fromTestCase((TestCase)execution.getReferencedTestCase());
        List executionSteps = execution.getSteps();
        int totalStepNumber = executionSteps.size();
        long buggedStepId = buggedStep.getId();
        return switch (testCaseKind) {
            case TestCaseKind.STANDARD -> BugTrackerControllerHelper.getAdditionalInformationForStandardTestCase(executionSteps, buggedStepId, totalStepNumber, locale, messageSource);
            case TestCaseKind.GHERKIN -> BugTrackerControllerHelper.getAdditionalInformationForScriptedTestCase(executionSteps, buggedStepId, totalStepNumber, locale, messageSource);
            case TestCaseKind.KEYWORD -> BugTrackerControllerHelper.getAdditionalInformationForKeywordTestCase(executionSteps, buggedStepId, totalStepNumber, locale, messageSource);
            default -> throw new IllegalArgumentException("The Kind " + String.valueOf(testCaseKind) + " for a Test Case does not exist.");
        };
    }

    @Deprecated
    private static String getAdditionalInformationForStandardTestCase(List<ExecutionStep> executionSteps, long buggedStepId, int totalStepNumber, Locale locale, MessageSource messageSource) {
        StringBuilder builder = new StringBuilder();
        for (ExecutionStep step : executionSteps) {
            BugTrackerControllerHelper.appendStepTitle(locale, messageSource, totalStepNumber, builder, step);
            String actionText = HTMLCleanupUtils.htmlToTrimmedText((String)step.getAction());
            String expectedResult = HTMLCleanupUtils.htmlToTrimmedText((String)step.getExpectedResult());
            builder.append(messageSource.getMessage("issue.default.additionalInformation.action", null, locale));
            builder.append(actionText);
            builder.append(messageSource.getMessage("issue.default.additionalInformation.expectedResult", null, locale));
            builder.append(expectedResult);
            builder.append(INSERT_NEW_LINES);
            if (step.getId().equals(buggedStepId)) break;
        }
        return builder.toString();
    }

    @Deprecated
    private static String getAdditionalInformationForScriptedTestCase(List<ExecutionStep> executionSteps, long buggedStepId, int totalStepNumber, Locale locale, MessageSource messageSource) {
        StringBuilder builder = new StringBuilder();
        for (ExecutionStep step : executionSteps) {
            BugTrackerControllerHelper.appendStepTitle(locale, messageSource, totalStepNumber, builder, step);
            String scriptTextWithCarriageReturns = step.getAction().replace("</br>", "<br/>");
            String scriptText = HTMLCleanupUtils.htmlToTrimmedText((String)scriptTextWithCarriageReturns);
            builder.append(messageSource.getMessage("issue.default.additionalInformation.script", null, locale));
            builder.append(scriptText);
            builder.append(INSERT_NEW_LINES);
            if (step.getId().equals(buggedStepId)) break;
        }
        return builder.toString();
    }

    @Deprecated
    private static String getAdditionalInformationForKeywordTestCase(List<ExecutionStep> executionSteps, long buggedStepId, int totalStepNumber, Locale locale, MessageSource messageSource) {
        StringBuilder builder = new StringBuilder();
        for (ExecutionStep step : executionSteps) {
            BugTrackerControllerHelper.appendStepTitle(locale, messageSource, totalStepNumber, builder, step);
            String content = HTMLCleanupUtils.htmlToTrimmedText((String)step.getAction());
            builder.append(content);
            builder.append(INSERT_NEW_LINES);
            if (step.getId().equals(buggedStepId)) break;
        }
        return builder.toString();
    }

    @Deprecated
    private static void appendStepTitle(Locale locale, MessageSource messageSource, int totalStepNumber, StringBuilder builder, ExecutionStep step) {
        builder.append("=============================================\n|    ");
        builder.append(messageSource.getMessage("issue.default.additionalInformation.step", null, locale));
        builder.append(" ");
        builder.append(step.getExecutionStepOrder() + 1);
        builder.append("/");
        builder.append(totalStepNumber);
        builder.append("\n=============================================\n");
    }

    @Deprecated
    public static String getDefaultDescription(Execution execution, Locale locale, MessageSource messageSource, String executionUrl) {
        StringBuilder description = new StringBuilder();
        BugTrackerControllerHelper.appendTestCaseDesc(execution.getReferencedTestCase(), description, locale, messageSource);
        BugTrackerControllerHelper.appendExecutionDesc(description, locale, messageSource, executionUrl);
        BugTrackerControllerHelper.appendDescHeader(description, locale, messageSource);
        return description.toString();
    }

    @Deprecated
    public static String getDefaultDescription(ExecutionStep step, Locale locale, MessageSource messageSource, String executionUrl) {
        StringBuilder description = new StringBuilder();
        BugTrackerControllerHelper.appendTestCaseDesc(step.getExecution().getReferencedTestCase(), description, locale, messageSource);
        BugTrackerControllerHelper.appendExecutionDesc(description, locale, messageSource, executionUrl);
        BugTrackerControllerHelper.appendStepDesc(step, description, locale, messageSource);
        BugTrackerControllerHelper.appendDescHeader(description, locale, messageSource);
        return description.toString();
    }

    @Deprecated
    private static void appendDescHeader(StringBuilder description, Locale locale, MessageSource messageSource) {
        description.append("\n# ");
        description.append(messageSource.getMessage("issue.default.description.description", null, locale));
        description.append(" :\n");
    }

    @Deprecated
    private static void appendStepDesc(ExecutionStep step, StringBuilder description, Locale locale, MessageSource messageSource) {
        description.append("# ");
        description.append(messageSource.getMessage("issue.default.description.concernedStep", null, locale));
        description.append(": ");
        description.append(step.getExecutionStepOrder() + 1);
        description.append("/");
        description.append(step.getExecution().getSteps().size());
        description.append("\n");
    }

    @Deprecated
    private static void appendExecutionDesc(StringBuilder description, Locale locale, MessageSource messageSource, String executionUrl) {
        description.append("# ");
        description.append(messageSource.getMessage("issue.default.description.execution", null, locale));
        description.append(": ");
        description.append(executionUrl);
        description.append("\n");
    }

    @Deprecated
    private static void appendTestCaseDesc(TestCase testCase, StringBuilder description, Locale locale, MessageSource messageSource) {
        if (testCase != null) {
            description.append("# ");
            description.append(messageSource.getMessage("issue.default.description.testCase", null, locale));
            description.append(": [");
            description.append(HTMLCleanupUtils.cleanAndUnescapeHTML((String)testCase.getReference()));
            description.append("] ");
            description.append(HTMLCleanupUtils.cleanAndUnescapeHTML((String)testCase.getName()));
            description.append("\n");
        }
    }
}

