/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.actionword;

import jakarta.inject.Inject;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.service.actionword.ActionWordParameterService;

@RestController
@RequestMapping(value={"backend/action-word/{actionWordId}/parameters"})
public class ActionWordParametersController {
    @Inject
    private ActionWordParameterService actionWordParameterService;

    @PostMapping(value={"{parameterId}/name"}, params={"value"})
    public String renameParameter(@PathVariable long parameterId, @RequestParam(value="value") String newName) {
        this.actionWordParameterService.renameParameter(parameterId, newName);
        return HtmlUtils.htmlEscape((String)newName);
    }

    @PostMapping(value={"{parameterId}/default-value"}, params={"value"})
    public String updateParameterDefaultValue(@PathVariable long parameterId, @RequestParam(value="value") String newDefaultValue) {
        this.actionWordParameterService.updateParameterDefaultValue(parameterId, newDefaultValue);
        return HtmlUtils.htmlEscape((String)newDefaultValue);
    }
}

