/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller;

import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.feature.experimental.ExperimentalFeatureManager;

@Controller
public class IndexController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexController.class);
    private final ExperimentalFeatureManager experimentalFeatureManager;

    public IndexController(ExperimentalFeatureManager experimentalFeatureManager) {
        this.experimentalFeatureManager = experimentalFeatureManager;
    }

    @GetMapping(value={"/index"})
    public String index(Model model) {
        List<String> flags = this.experimentalFeatureManager.getEnabledFeatures().stream().map(Enum::name).toList();
        model.addAttribute("experimentalFeatureFlags", flags);
        LOGGER.debug("Page request forwarded to SquashTM index controller. Single page app will be served with current context path.", new Object[0]);
        LOGGER.debug("Experimental feature flags: {}", new Object[]{flags});
        return "index.html";
    }
}

