/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.thymeleaf.processor.attr;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;
import org.squashtest.tm.web.thymeleaf.processor.attr.Constants;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.TemplateModel;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;

public final class SquashUnsafeHtmlAttrProcessor
extends AbstractAttributeTagProcessor
implements IElementTagProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashUnsafeHtmlAttrProcessor.class);
    private static final String ATTRIBUTE_NAME = "unsafe-html";
    private static final int PRECEDENCE = 1200;

    public SquashUnsafeHtmlAttrProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, Constants.MATCH_ANY_TAG, false, ATTRIBUTE_NAME, true, 1200, true);
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        LOGGER.trace("Will process attribute value {} of element {}", (Object)attributeValue, (Object)tag);
        IEngineConfiguration configuration = context.getConfiguration();
        IStandardExpressionParser parser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
        IStandardExpression expression = parser.parseExpression((IExpressionContext)context, attributeValue);
        Object html = expression.execute((IExpressionContext)context);
        String htmlString = html == null ? "" : HTMLCleanupUtils.cleanHtml(html.toString());
        TemplateModel parsed = configuration.getTemplateManager().parseString(context.getTemplateData(), htmlString, 0, 0, null, false);
        structureHandler.setBody((IModel)parsed, false);
    }
}

