/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.thymeleaf.processor.attr;

import org.squashtest.tm.web.thymeleaf.processor.attr.Constants;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.DateUtils;

public class SquashIso8601DateAttrProcessor
extends AbstractAttributeTagProcessor
implements IElementTagProcessor {
    private static final int PRECEDENCE = 1000;
    private static final String SQ_TIMESTAMP = "iso-date";

    public SquashIso8601DateAttrProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, Constants.MATCH_ANY_TAG, false, SQ_TIMESTAMP, true, 1000, true);
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        IStandardExpressionParser parser = StandardExpressions.getExpressionParser((IEngineConfiguration)context.getConfiguration());
        IStandardExpression expression = parser.parseExpression((IExpressionContext)context, attributeValue);
        Object parsed = expression.execute((IExpressionContext)context);
        String asString = parsed == null ? "" : DateUtils.formatISO((Object)parsed);
        structureHandler.setBody((CharSequence)asString, false);
    }
}

