/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.thymeleaf.processor.attr;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.web.thymeleaf.processor.attr.Constants;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;

public class SquashCssAttrProcessor
extends AbstractAttributeTagProcessor
implements IElementTagProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashCssAttrProcessor.class);
    private static final String SQ_CSS = "css";
    private static final String HREF = "href";
    private static final int PRECEDENCE = 1300;
    private String versionPathToken;

    public SquashCssAttrProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, Constants.MATCH_ANY_TAG, false, SQ_CSS, true, 1300, true);
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        IStandardExpressionParser parser = StandardExpressions.getExpressionParser((IEngineConfiguration)context.getConfiguration());
        String cssUrlExpression = "@{" + attributeValue + "}";
        LOGGER.debug("Stylesheet named '{}' will be resolved using the expression '{}'", (Object)attributeValue, (Object)cssUrlExpression);
        String toEvaluate = "@{/styles" + this.getVersionPathToken((IContext)context) + '/' + attributeValue + "}";
        IStandardExpression expression = parser.parseExpression((IExpressionContext)context, toEvaluate);
        String evaluatedUrl = (String)expression.execute((IExpressionContext)context);
        LOGGER.trace("Stylesheet resolved to url '{}'", (Object)evaluatedUrl);
        structureHandler.setAttribute(HREF, evaluatedUrl);
    }

    private String getVersionPathToken(IContext context) {
        if (this.versionPathToken == null) {
            this.initSquashVersion(context);
        }
        return this.versionPathToken;
    }

    private void initSquashVersion(IContext context) {
        if (this.versionPathToken == null && context instanceof IWebContext) {
            IWebContext webContext = (IWebContext)context;
            String squashVersion = webContext.getServletContext().getInitParameter("squashTMVersion");
            this.versionPathToken = squashVersion != null ? String.valueOf('-') + squashVersion : "";
        }
    }
}

