/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.thymeleaf.dialect;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collection;
import javax.servlet.ServletContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.api.export.ExportPlugin;
import org.squashtest.tm.api.wizard.WorkspacePluginIcon;
import org.squashtest.tm.api.wizard.WorkspaceWizard;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.service.internal.dto.CustomFieldModel;
import org.squashtest.tm.service.internal.dto.FilterModel;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.squashtest.tm.web.internal.plugins.manager.export.ExportPluginManager;
import org.squashtest.tm.web.internal.plugins.manager.wizard.WorkspaceWizardManager;

public class WorkspaceHelper {
    public static final String HELPER_NAME = "workspace";
    private final ServletContext servletContext;

    public WorkspaceHelper(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Collection<BugTracker> visibleBugtrackers() {
        return org.squashtest.tm.web.internal.helper.WorkspaceHelper.getVisibleBugtrackers(this.servletContext);
    }

    public Collection<WorkspacePluginIcon> authorizedWorkspacePluginIcons() {
        return org.squashtest.tm.web.internal.helper.WorkspaceHelper.getAuthorizedWorkspacePluginIcons(this.servletContext);
    }

    public FilterModel projectFilter() {
        return org.squashtest.tm.web.internal.helper.WorkspaceHelper.getProjectFilter(this.servletContext);
    }

    public Collection<ExportPlugin> exportPlugins(String workspaceName) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
        WorkspaceType workspace = WorkspaceType.valueOf((String)workspaceName);
        ExportPluginManager manager = (ExportPluginManager)wac.getBean(ExportPluginManager.class);
        return manager.findAllByWorkspace(workspace);
    }

    public Collection<WorkspaceWizard> wizardPlugins(String workspaceName) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
        WorkspaceWizardManager wizardManager = (WorkspaceWizardManager)wac.getBean(WorkspaceWizardManager.class);
        WorkspaceType type = WorkspaceType.valueOf((String)workspaceName);
        return wizardManager.findAllByWorkspace(type);
    }

    public Object property(String pptName) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
        PropertySourcesPlaceholderConfigurer configurer = (PropertySourcesPlaceholderConfigurer)wac.getBean(PropertySourcesPlaceholderConfigurer.class);
        PropertySources sources = configurer.getAppliedPropertySources();
        Object found = null;
        for (PropertySource src : sources) {
            if (src.getProperty(pptName) == null) continue;
            found = src.getProperty(pptName);
            break;
        }
        return found;
    }

    public String jacksonSerializer(Object toSerialize) {
        return JsonHelper.serialize(toSerialize);
    }

    public String cufdefSerializer(Collection<CustomFieldModel> toSerialize) throws JsonProcessingException {
        return JsonHelper.serializeCustomfields(toSerialize);
    }
}

