/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.thymeleaf.dialect;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.squashtest.tm.annotation.WebComponent;
import org.squashtest.tm.web.thymeleaf.dialect.WorkspaceHelper;
import org.squashtest.tm.web.thymeleaf.processor.attr.SquashCssAttrProcessor;
import org.squashtest.tm.web.thymeleaf.processor.attr.SquashIso8601DateAttrProcessor;
import org.squashtest.tm.web.thymeleaf.processor.attr.SquashUnsafeHtmlAttrProcessor;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dialect.AbstractProcessorDialect;
import org.thymeleaf.dialect.IExpressionObjectDialect;
import org.thymeleaf.dialect.IProcessorDialect;
import org.thymeleaf.expression.IExpressionObjectFactory;
import org.thymeleaf.processor.IProcessor;

@WebComponent(value="thymeleaf.dialect.squashdialect")
public class SquashDialect
extends AbstractProcessorDialect
implements IProcessorDialect,
IExpressionObjectDialect {
    public static final String SQUASH_DIALECT = "SquashDialect";
    public static final String PREFIX = "sq";
    public static final int PRECEDENCE = 1200;
    private static final ExpressionObjectFactory EXPRESSION_OBJECT_FACTORY = new ExpressionObjectFactory();

    public SquashDialect() {
        super(SQUASH_DIALECT, PREFIX, 1200);
    }

    public Set<IProcessor> getProcessors(String dialectPrefix) {
        HashSet<IProcessor> processors = new HashSet<IProcessor>(3);
        processors.add((IProcessor)new SquashUnsafeHtmlAttrProcessor(dialectPrefix));
        processors.add((IProcessor)new SquashCssAttrProcessor(dialectPrefix));
        processors.add((IProcessor)new SquashIso8601DateAttrProcessor(dialectPrefix));
        return processors;
    }

    public IExpressionObjectFactory getExpressionObjectFactory() {
        return EXPRESSION_OBJECT_FACTORY;
    }

    private static final class ExpressionObjectFactory
    implements IExpressionObjectFactory {
        private static final Set<String> HELPERS = new HashSet<String>();

        static {
            HELPERS.add("workspace");
        }

        private ExpressionObjectFactory() {
        }

        public Set<String> getAllExpressionObjectNames() {
            return HELPERS;
        }

        public Object buildObject(IExpressionContext context, String expressionObjectName) {
            WorkspaceHelper result = null;
            if (context instanceof IWebContext) {
                IWebContext webContext = (IWebContext)context;
                ServletContext servletContext = webContext.getServletContext();
                result = new WorkspaceHelper(servletContext);
            }
            return result;
        }

        public boolean isCacheable(String expressionObjectName) {
            return false;
        }
    }
}

