/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.util;

import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;
import org.springframework.web.util.HtmlUtils;

public final class HTMLCleanupUtils {
    private static final String STYLE = "style";
    private static final String CLASS = "class";

    private HTMLCleanupUtils() {
    }

    public static String htmlToText(String html) {
        String fixedHtml = html != null ? html : "";
        String replacedHtml = fixedHtml.replaceFirst("\n", "");
        Source htmlSource = new Source((CharSequence)replacedHtml);
        Segment htmlSegment = new Segment(htmlSource, 0, replacedHtml.length());
        Renderer htmlRend = new Renderer(htmlSegment);
        String encoded = htmlRend.toString();
        return encoded.trim();
    }

    public static String forceHtmlEscape(String html) {
        String fixedHtml = html != null ? html : "";
        String unescaped = HtmlUtils.htmlUnescape((String)fixedHtml);
        return HtmlUtils.htmlEscape((String)unescaped);
    }

    public static String escapeOrDefault(String toEscape, String defaultString) {
        return toEscape != null ? HtmlUtils.htmlEscape((String)toEscape) : defaultString;
    }

    public static String stripJavascript(String json) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            Document.OutputSettings outputSettings = new Document.OutputSettings();
            outputSettings.prettyPrint(false);
            outputSettings.outline(false);
            String cleaned = Jsoup.clean((String)json, (String)"", (Whitelist)Whitelist.relaxed(), (Document.OutputSettings)outputSettings);
            return HtmlUtils.htmlUnescape((String)cleaned);
        }
        return "";
    }

    public static String getCleanedBriefText(String text, int maxLength) {
        if ((text = HTMLCleanupUtils.htmlToText(HTMLCleanupUtils.cleanHtml(text))).length() > maxLength) {
            text = String.valueOf(text.substring(0, maxLength - 3)) + "...";
        }
        return text;
    }

    public static String cleanHtml(String unsecureHtml) {
        if (StringUtils.isNotBlank((CharSequence)unsecureHtml)) {
            Document.OutputSettings outputSettings = new Document.OutputSettings();
            outputSettings.prettyPrint(false);
            outputSettings.outline(false);
            return Jsoup.clean((String)unsecureHtml, (String)"", (Whitelist)Whitelist.relaxed().addAttributes("a", new String[]{"accesskey", "charset", CLASS, "dir", "lang", "name", "rel", STYLE, "tabindex", "target", "type"}).addProtocols("img", "src", new String[]{"cid", "data", "http", "https"}).addAttributes("img", new String[]{CLASS, "dir", "lang", "longdesc", STYLE}).addAttributes("li", new String[]{CLASS, STYLE}).addAttributes("p", new String[]{CLASS, STYLE}).addAttributes("span", new String[]{CLASS, STYLE}).addAttributes("table", new String[]{"align", "border", "cellpadding", "cellspacing", CLASS, "dir", STYLE}).addAttributes("ul", new String[]{CLASS, STYLE}).addAttributes("ol", new String[]{CLASS, STYLE}).addAttributes("td", new String[]{CLASS, STYLE}).addTags(new String[]{"s"}), (Document.OutputSettings)outputSettings);
        }
        return "";
    }

    public static String cleanAndUnescapeHTML(String unsecureHtml) {
        return HtmlUtils.htmlUnescape((String)HTMLCleanupUtils.cleanHtml(unsecureHtml));
    }
}

