/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.security.authentication;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Scope;
import org.springframework.core.task.TaskExecutor;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.IdentifiedUtil;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.servers.UserCredentialsCache;

@Component
public class BugTrackerAutoconnectCallback
implements ApplicationListener<InteractiveAuthenticationSuccessEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BugTrackerAutoconnectCallback.class);
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private CredentialsProvider credentialsProvider;
    @Inject
    private FeatureManager featureManager;
    @Inject
    private Provider<AsynchronousBugTrackerAutoconnect> asyncProvider;

    public void onApplicationEvent(InteractiveAuthenticationSuccessEvent event) {
        Authentication authentication = event.getAuthentication();
        HttpSession session = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getSession();
        UserCredentialsCache credentialsCache = this.initializeCredentialsCache(authentication.getName(), session);
        this.scheduleAutoconnection(authentication, credentialsCache);
    }

    private UserCredentialsCache initializeCredentialsCache(String username, HttpSession session) {
        LOGGER.debug("BugTrackerAutoconnectCallback : initializing the credentials cache");
        UserCredentialsCache credentials = new UserCredentialsCache(username, this.featureManager);
        session.setAttribute("squashtest.servers.UserCredentialsCache", (Object)credentials);
        this.credentialsProvider.restoreCache(credentials);
        return credentials;
    }

    private void scheduleAutoconnection(Authentication authentication, UserCredentialsCache credentialsCache) {
        LOGGER.debug("BugTrackerAutoconnectCallback : scheduling autoconnection for user '{}'", (Object)credentialsCache.getUser());
        AsynchronousBugTrackerAutoconnect autoconnector = (AsynchronousBugTrackerAutoconnect)this.asyncProvider.get();
        autoconnector.setUser(authentication.getName());
        autoconnector.setSpringsecCredentials(authentication.getCredentials());
        autoconnector.setCredentialsCache(credentialsCache);
        this.taskExecutor.execute((Runnable)autoconnector);
    }

    @Component
    @Scope(value="prototype")
    static class AsynchronousBugTrackerAutoconnect
    implements Runnable {
        private String user;
        private Object springsecCredentials;
        private UserCredentialsCache credentialsCache;
        private final SecurityContext secContext = SecurityContextHolder.getContext();
        @Inject
        private BugTrackersLocalService bugTrackersLocalService;
        @Inject
        private ProjectFinder projectFinder;
        @Inject
        private BugTrackerFinderService bugTrackerFinder;
        @Inject
        private CredentialsProvider credentialsProvider;
        @Inject
        private FeatureManager featureManager;

        @Override
        public void run() {
            SecurityContextHolder.setContext((SecurityContext)this.secContext);
            this.credentialsProvider.restoreCache(this.credentialsCache);
            try {
                List<BugTracker> servers = this.findBugTrackers();
                for (BugTracker server : servers) {
                    try {
                        LOGGER.debug("BugTrackerAutoconnectCallback : attempting authentication on server '{}'", (Object)server.getName());
                        this.attemptAuthentication(server);
                    }
                    catch (BugTrackerNoCredentialsException | UnsupportedAuthenticationModeException ex) {
                        LOGGER.debug("BugTrackerAutoconnectCallback : Failed to connect user '{}' to the bugtracker {} with the supplied credentials. User will have to connect manually.", (Object)this.user, (Object)server);
                        LOGGER.debug("BugTrackerAutoconnectCallback : original exception is : ", ex);
                    }
                    catch (Exception genericException) {
                        LOGGER.error("BugTrackerAutoconnectCallback : an unexpected error happened :", (Throwable)genericException);
                    }
                }
            }
            finally {
                LOGGER.debug("BugTrackerAutoconnectCallback : completed autoconnection for user '{}'", (Object)this.credentialsCache.getUser());
                this.credentialsProvider.unloadCache();
            }
        }

        private void attemptAuthentication(BugTracker server) {
            AuthenticationPolicy policy = server.getAuthenticationPolicy();
            AuthenticationProtocol protocol = server.getAuthenticationProtocol();
            LOGGER.trace("server '{}' is set to authentication policy '{}' and protocol '{}'", (Object)policy, (Object)protocol);
            Credentials credentials = this.fetchCredentialsOrNull(server);
            if (credentials == null) {
                LOGGER.debug("BugTrackerAutoconnectCallback : could not find suitable credentials, skipping");
            } else {
                this.warnIfCredentialsOfWrongType(credentials, protocol);
                this.bugTrackersLocalService.validateCredentials(server, credentials, true);
                LOGGER.debug("BugTrackerAutoconnectCallback : credentials successfully tested for server '{}'", (Object)server.getName());
            }
        }

        private Credentials fetchCredentialsOrNull(BugTracker server) {
            Credentials credentials = null;
            AuthenticationPolicy policy = server.getAuthenticationPolicy();
            Optional maybeCredentials = null;
            maybeCredentials = policy == AuthenticationPolicy.USER ? this.credentialsProvider.getCredentials((ThirdPartyServer)server) : this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)server);
            if (maybeCredentials.isPresent()) {
                LOGGER.debug("BugTrackerAutoconnectCallback : found credentials from the provider");
                credentials = (Credentials)maybeCredentials.get();
            } else if (this.canTryUsingEvent(server)) {
                LOGGER.debug("BugTrackerAutoconnectCallback : can create the credentials using the authentication event");
                credentials = this.buildFromAuthenticationEvent();
            }
            return credentials;
        }

        private List<BugTracker> findBugTrackers() {
            List readableProjects = this.projectFinder.findAllReadable();
            List projectIds = IdentifiedUtil.extractIds((Collection)readableProjects);
            return this.bugTrackerFinder.findDistinctBugTrackersForProjects(projectIds);
        }

        private boolean canTryUsingEvent(BugTracker server) {
            return server.getAuthenticationPolicy() == AuthenticationPolicy.USER && server.getAuthenticationProtocol() == AuthenticationProtocol.BASIC_AUTH && this.springsecCredentials instanceof String && this.featureManager.isEnabled(FeatureManager.Feature.AUTOCONNECT_ON_CONNECTION);
        }

        private Credentials buildFromAuthenticationEvent() {
            return new BasicAuthenticationCredentials(this.user, (String)this.springsecCredentials);
        }

        private void warnIfCredentialsOfWrongType(Credentials credentials, AuthenticationProtocol protocol) {
            AuthenticationProtocol credsProtocol = credentials.getImplementedProtocol();
            if (credsProtocol != protocol) {
                LOGGER.warn("BugTrackerAutoconnectCallback : attempting autoconnection with credentials for protocol '{}' while the configuration states that the (preferred) protocol is  '{}'. That doesn't mean the current credentials won't work (the connector still supports them) but this warning hints that they might be obsolete regarding your new preferred protocol.", (Object)credsProtocol, (Object)protocol);
            }
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setSpringsecCredentials(Object springsecCredentials) {
            this.springsecCredentials = springsecCredentials;
        }

        public void setCredentialsCache(UserCredentialsCache credentialsCache) {
            this.credentialsCache = credentialsCache;
        }
    }
}

