/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.report.criteria;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.form.InputType;
import org.squashtest.tm.web.internal.report.criteria.CheckboxEntryConverter;
import org.squashtest.tm.web.internal.report.criteria.DateEntryConverter;
import org.squashtest.tm.web.internal.report.criteria.EmptyCriteria;
import org.squashtest.tm.web.internal.report.criteria.FormEntryNotConvertibleException;
import org.squashtest.tm.web.internal.report.criteria.GenericSimpleEntryConverter;
import org.squashtest.tm.web.internal.report.criteria.InconsistentMultiValuedEntryException;
import org.squashtest.tm.web.internal.report.criteria.MultiOptionsCriteria;
import org.squashtest.tm.web.internal.report.criteria.MultiValuesCriteria;
import org.squashtest.tm.web.internal.report.criteria.SimpleCriteria;
import org.squashtest.tm.web.internal.report.criteria.SimpleEntryConverter;

public class FormToCriteriaConverter {
    private static final String INPUT_SELECTED = "selected";
    private static final String INPUT_VALUE = "value";
    private static final String INPUT_TYPE = "type";
    private static final Logger LOGGER = LoggerFactory.getLogger(FormToCriteriaConverter.class);
    private final Map<InputType, SimpleEntryConverter> simpleEntryConverterByType;
    private final SimpleEntryConverter simpleEntryDefaultConverter = new GenericSimpleEntryConverter();

    public FormToCriteriaConverter() {
        this.simpleEntryConverterByType = new HashMap<InputType, SimpleEntryConverter>();
        this.simpleEntryConverterByType.put(InputType.DATE, new DateEntryConverter());
        this.simpleEntryConverterByType.put(InputType.CHECKBOX, new CheckboxEntryConverter());
        this.simpleEntryConverterByType.put(InputType.TEXT, this.simpleEntryDefaultConverter);
        this.simpleEntryConverterByType.put(InputType.PASSWORD, this.simpleEntryDefaultConverter);
        this.simpleEntryConverterByType.put(InputType.TREE_PICKER, this.simpleEntryDefaultConverter);
        this.simpleEntryConverterByType.put(InputType.MILESTONE_PICKER, this.simpleEntryDefaultConverter);
        this.simpleEntryConverterByType.put(InputType.TAG_PICKER, this.simpleEntryDefaultConverter);
    }

    public Map<String, Criteria> convert(Map<String, Object> formValues) {
        HashMap<String, Criteria> res = new HashMap<String, Criteria>();
        for (Map.Entry<String, Object> entry : formValues.entrySet()) {
            Criteria crit;
            String name = entry.getKey();
            Object inputValue = entry.getValue();
            if (inputValue instanceof Collection) {
                Collection optionValues = (Collection)inputValue;
                crit = this.convertMultiValuedEntry(name, optionValues);
                res.put(name, crit);
                continue;
            }
            if (inputValue instanceof Map) {
                Map map = (Map)inputValue;
                crit = this.convertSimpleEntry(name, map);
                res.put(name, crit);
                continue;
            }
            LOGGER.error("Form {} contains non convertible entry {}", formValues, entry);
            throw new FormEntryNotConvertibleException(entry);
        }
        return res;
    }

    private Criteria convertMultiValuedEntry(String name, Collection<Map<String, Object>> multiValued) {
        InputType inputType = this.extractInputType(multiValued);
        return this.convertMultiValuedEntry(name, multiValued, inputType);
    }

    private Criteria convertMultiValuedEntry(String name, Collection<Map<String, Object>> multiValued, InputType inputType) {
        Criteria res;
        switch (inputType) {
            case TREE_PICKER: {
                res = this.createNodeMapCriteria(name, multiValued, inputType);
                break;
            }
            case CHECKBOXES_GROUP: 
            case PROJECT_PICKER: {
                res = this.createMultiOptionsCriteria(name, multiValued, inputType);
                break;
            }
            case DROPDOWN_LIST: 
            case RADIO_BUTTONS_GROUP: {
                res = this.createSingleOptionCriteria(name, multiValued, inputType);
                break;
            }
            case MILESTONE_PICKER: {
                res = this.createMilestoneMultiCriteria(name, multiValued, inputType);
                break;
            }
            case TAG_PICKER: {
                res = this.createTagCriteria(name, multiValued, inputType);
                break;
            }
            default: {
                res = EmptyCriteria.createEmptyCriteria(name, inputType);
            }
        }
        return res;
    }

    private Criteria createTagCriteria(String name, Collection<Map<String, Object>> multiValued, InputType inputType) {
        MultiOptionsCriteria crit = new MultiOptionsCriteria(name, inputType);
        for (Map<String, Object> valueItem : multiValued) {
            Collection tags = (Collection)valueItem.get(INPUT_VALUE);
            for (String tag : tags) {
                crit.addOption(tag, Boolean.TRUE);
            }
        }
        return crit;
    }

    private Criteria createNodeMapCriteria(String name, Collection<Map<String, Object>> multiValued, InputType inputType) {
        MultiValuesCriteria crit = new MultiValuesCriteria(name, inputType);
        for (Map<String, Object> valueItem : multiValued) {
            String nodeType = (String)valueItem.get("nodeType");
            Object value = valueItem.get(INPUT_VALUE);
            crit.addValue(nodeType, value);
        }
        return crit;
    }

    private Criteria createSingleOptionCriteria(String name, Collection<Map<String, Object>> multiValued, InputType inputType) {
        for (Map<String, Object> valueItem : multiValued) {
            Boolean selected = (Boolean)valueItem.get(INPUT_SELECTED);
            if (!selected.booleanValue()) continue;
            return new SimpleCriteria<String>(name, (String)valueItem.get(INPUT_VALUE), inputType);
        }
        return new EmptyCriteria(name, inputType);
    }

    private Criteria createMultiOptionsCriteria(String name, Collection<Map<String, Object>> multiValued, InputType inputType) {
        MultiOptionsCriteria crit = new MultiOptionsCriteria(name, inputType);
        for (Map<String, Object> valueItem : multiValued) {
            Boolean selected = (Boolean)valueItem.get(INPUT_SELECTED);
            Object value = valueItem.get(INPUT_VALUE);
            crit.addOption(value, selected);
        }
        return crit;
    }

    private Criteria createMilestoneMultiCriteria(String name, Collection<Map<String, Object>> multiValued, InputType inputType) {
        MultiOptionsCriteria crit = new MultiOptionsCriteria(name, inputType);
        for (Map<String, Object> valueItem : multiValued) {
            Collection selectedIds = (Collection)valueItem.get(INPUT_VALUE);
            for (Integer id : selectedIds) {
                crit.addOption(id, Boolean.TRUE);
            }
        }
        return crit;
    }

    private InputType extractInputType(Collection<Map<String, Object>> multiValued) {
        String type = null;
        for (Map<String, Object> valueItem : multiValued) {
            if (type == null) {
                type = (String)valueItem.get(INPUT_TYPE);
                continue;
            }
            if (type.equals(valueItem.get(INPUT_TYPE))) continue;
            throw new InconsistentMultiValuedEntryException(multiValued);
        }
        return InputType.valueOf(type);
    }

    private Criteria convertSimpleEntry(String name, Map<String, Object> entry) {
        String type = (String)entry.get(INPUT_TYPE);
        InputType inputType = InputType.valueOf((String)type);
        return this.simpleEntryConverter(inputType).convertEntry(name, entry, inputType);
    }

    private SimpleEntryConverter simpleEntryConverter(InputType type) {
        SimpleEntryConverter converter = this.simpleEntryConverterByType.get(type);
        if (converter == null) {
            converter = this.simpleEntryDefaultConverter;
        }
        return converter;
    }
}

