/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.collections.map.MultiValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.report.BasicReport;
import org.squashtest.tm.api.report.Report;
import org.squashtest.tm.api.report.ReportPlugin;
import org.squashtest.tm.api.report.StandardReportCategory;
import org.squashtest.tm.web.internal.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.internal.report.ReportIdentifier;

@Component
public class ReportsRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportsRegistry.class);
    private static final String UNCHECKED = "unchecked";
    private final MultiValueMap reportsByCategory = new MultiValueMap();
    private final Map<ReportIdentifier, IdentifiedReportDecorator> reportByIdentifier = new ConcurrentHashMap<ReportIdentifier, IdentifiedReportDecorator>();
    @Autowired(required=false)
    private Collection<ReportPlugin> plugins = Collections.emptyList();
    @Inject
    private MessageSource i18nHelper;

    @PostConstruct
    public void registerReports() {
        for (ReportPlugin plugin : this.plugins) {
            Report[] reports;
            Report[] reportArray = reports = plugin.getReports();
            int n = reports.length;
            int n2 = 0;
            while (n2 < n) {
                Report report = reportArray[n2];
                String pluginNamespace = report.getLabelKey();
                StandardReportCategory category = report.getCategory();
                IdentifiedReportDecorator identifiedReport = this.createIdentifiedReport(report, pluginNamespace);
                this.reportsByCategory.put((Object)category, (Object)identifiedReport);
                this.reportByIdentifier.put(identifiedReport.getIdentifier(), identifiedReport);
                LOGGER.info("Registered report [{}] under Category [{}] along with Namespace [{}]", new Object[]{report, category.getI18nKey(), pluginNamespace});
                ++n2;
            }
        }
    }

    private IdentifiedReportDecorator createIdentifiedReport(Report report, String pluginNamespace) {
        return new IdentifiedReportDecorator(report, pluginNamespace);
    }

    public Set<StandardReportCategory> getCategories() {
        return this.reportsByCategory.keySet();
    }

    public List<StandardReportCategory> getSortedCategories() {
        ArrayList<StandardReportCategory> sortedCategories = new ArrayList<StandardReportCategory>(this.getCategories());
        Collections.sort(sortedCategories, new CategorySorter(this.i18nHelper));
        return sortedCategories;
    }

    public Collection<IdentifiedReportDecorator> findReports(StandardReportCategory category) {
        Collection res = (Collection)this.reportsByCategory.get((Object)category);
        return res == null ? Collections.emptyList() : res;
    }

    public Map<StandardReportCategory, Collection<BasicReport>> getReportsByCategory() {
        return this.reportsByCategory;
    }

    public Map<StandardReportCategory, Collection<BasicReport>> getSortedReportsByCategory() {
        HashMap<StandardReportCategory, Collection<BasicReport>> sortedMap = new HashMap<StandardReportCategory, Collection<BasicReport>>(this.reportsByCategory.size());
        for (StandardReportCategory categ : this.reportsByCategory.keySet()) {
            ArrayList sortedReports = new ArrayList(this.reportsByCategory.getCollection((Object)categ));
            Collections.sort(sortedReports, new ReportSorter());
            sortedMap.put(categ, sortedReports);
        }
        return sortedMap;
    }

    public Report findReport(String namespace) {
        return this.reportByIdentifier.get(new ReportIdentifier(namespace));
    }

    private static class CategorySorter
    implements Comparator<StandardReportCategory> {
        private MessageSource i18nHelper;

        CategorySorter(MessageSource helper) {
            this.i18nHelper = helper;
        }

        @Override
        public int compare(StandardReportCategory category1, StandardReportCategory category2) {
            Locale locale = LocaleContextHolder.getLocale();
            String name1 = this.i18nHelper.getMessage(category1.getI18nKey(), null, locale);
            String name2 = this.i18nHelper.getMessage(category2.getI18nKey(), null, locale);
            return name1.compareTo(name2);
        }
    }

    private static class ReportSorter
    implements Comparator<Report> {
        private ReportSorter() {
        }

        @Override
        public int compare(Report report1, Report report2) {
            String name1 = report1.getLabel();
            String name2 = report2.getLabel();
            return name1.compareTo(name2);
        }
    }
}

