/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.plugins.manager.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.MultiValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.squashtest.tm.api.wizard.WorkspaceWizard;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.library.PluginReferencer;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.LibraryPluginBinding;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.web.internal.plugins.manager.wizard.WorkspaceWizardManager;

@Service
public class WorkspaceWizardManagerImpl
implements WorkspaceWizardManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkspaceWizardManagerImpl.class);
    @Autowired(required=false)
    private Collection<WorkspaceWizard> wizards = Collections.emptyList();
    private final MultiValueMap wizardsByWorkspace = new MultiValueMap();
    @Inject
    private GenericProjectFinder projectFinder;
    @Inject
    private GenericProjectManagerService projectManager;

    @PostConstruct
    public void registerWizards() {
        for (WorkspaceWizard wizard : this.wizards) {
            LOGGER.info("Registering workspace wizard {} for workspace {}", (Object)wizard, (Object)wizard.getDisplayWorkspace());
            this.wizardsByWorkspace.put((Object)wizard.getDisplayWorkspace(), (Object)wizard);
        }
    }

    @Override
    public Collection<WorkspaceWizard> findAllByWorkspace(WorkspaceType workspace) {
        Collection collection = this.wizardsByWorkspace.getCollection((Object)workspace);
        if (collection == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(collection);
    }

    @Override
    public WorkspaceWizard findById(String wizardId) {
        for (WorkspaceWizard wizard : this.findAll()) {
            if (!wizard.getId().equals(wizardId)) continue;
            return wizard;
        }
        throw new NoSuchElementException("cannot find WorkspaceWizard with id " + wizardId);
    }

    @Override
    public Collection<WorkspaceWizard> findAll() {
        return Collections.unmodifiableCollection(this.wizards);
    }

    @Override
    public Collection<WorkspaceWizard> findEnabledWizards(long projectId) {
        return this.findEnabledWizards(projectId, WorkspaceType.TEST_CASE_WORKSPACE, WorkspaceType.REQUIREMENT_WORKSPACE, WorkspaceType.CAMPAIGN_WORKSPACE);
    }

    @Override
    public Collection<WorkspaceWizard> findEnabledWizards(long projectId, WorkspaceType workspace) {
        Collection<WorkspaceWizard> allWizards = this.findAllByWorkspace(workspace);
        Collection<String> enabledWizardIds = this.findEnabledWizardIds(projectId, workspace);
        BelongsToList predicate = new BelongsToList(enabledWizardIds);
        return this.filterWizards(allWizards, predicate);
    }

    private Collection<WorkspaceWizard> filterWizards(Collection<WorkspaceWizard> wizards, Predicate predicate) {
        ArrayList<WorkspaceWizard> res = new ArrayList<WorkspaceWizard>(wizards);
        CollectionUtils.filter(res, (Predicate)predicate);
        return res;
    }

    @Override
    public Collection<WorkspaceWizard> findEnabledWizards(long projectId, WorkspaceType ... workspaces) {
        HashSet<WorkspaceWizard> allWizards = new HashSet<WorkspaceWizard>(this.wizards.size());
        WorkspaceType[] workspaceTypeArray = workspaces;
        int n = workspaces.length;
        int n2 = 0;
        while (n2 < n) {
            WorkspaceType workspace = workspaceTypeArray[n2];
            allWizards.addAll(this.findEnabledWizards(projectId, workspace));
            ++n2;
        }
        return allWizards;
    }

    @Override
    public Collection<WorkspaceWizard> findDisabledWizards(long projectId) {
        return this.findDisabledWizards(projectId, WorkspaceType.TEST_CASE_WORKSPACE, WorkspaceType.REQUIREMENT_WORKSPACE, WorkspaceType.CAMPAIGN_WORKSPACE);
    }

    @Override
    public Collection<WorkspaceWizard> findDisabledWizards(long projectId, WorkspaceType workspace) {
        Collection<WorkspaceWizard> allWizards = this.findAllByWorkspace(workspace);
        Collection<String> enabledWizardIds = this.findEnabledWizardIds(projectId, workspace);
        AbsentFromList predicate = new AbsentFromList(enabledWizardIds);
        return this.filterWizards(allWizards, predicate);
    }

    @Override
    public Collection<WorkspaceWizard> findDisabledWizards(long projectId, WorkspaceType ... workspaces) {
        HashSet<WorkspaceWizard> allWizards = new HashSet<WorkspaceWizard>();
        WorkspaceType[] workspaceTypeArray = workspaces;
        int n = workspaces.length;
        int n2 = 0;
        while (n2 < n) {
            WorkspaceType workspace = workspaceTypeArray[n2];
            allWizards.addAll(this.findDisabledWizards(projectId, workspace));
            ++n2;
        }
        return allWizards;
    }

    @Override
    public Boolean isActivePlugin(WorkspaceWizard plugin, long projectId) {
        PluginReferencer library = this.findLibrary(projectId, plugin.getDisplayWorkspace());
        LibraryPluginBinding binding = library.getPluginBinding(plugin.getId());
        return binding != null ? binding.getActive() : false;
    }

    @Override
    public Boolean isHasConfiguration(WorkspaceWizard plugin, long projectId) {
        WorkspaceType workspaceType = "squash.tm.plugin.jirasync".equals(plugin.getId()) ? WorkspaceType.REQUIREMENT_WORKSPACE : plugin.getDisplayWorkspace();
        Map pluginConfiguration = this.projectManager.getPluginConfiguration(projectId, workspaceType, plugin.getId());
        boolean hasRemoteSynchro = this.projectManager.hasProjectRemoteSynchronisation(projectId);
        if (pluginConfiguration.size() == 0 && !hasRemoteSynchro) {
            return false;
        }
        return true;
    }

    private PluginReferencer findLibrary(long projectId, WorkspaceType workspace) {
        GenericProject project = this.projectFinder.findById(projectId);
        switch (workspace) {
            case TEST_CASE_WORKSPACE: {
                return project.getTestCaseLibrary();
            }
            case REQUIREMENT_WORKSPACE: {
                return project.getRequirementLibrary();
            }
            case CAMPAIGN_WORKSPACE: {
                return project.getCampaignLibrary();
            }
        }
        throw new IllegalArgumentException("WorkspaceType " + workspace + " is unknown and not covered by this class");
    }

    private Collection<String> findEnabledWizardIds(long projectId, WorkspaceType workspace) {
        return this.findLibrary(projectId, workspace).getEnabledPlugins();
    }

    private static final class AbsentFromList
    implements Predicate {
        private Collection<String> wizardIds;

        public AbsentFromList(Collection<String> wizardIds) {
            this.wizardIds = wizardIds;
        }

        public boolean evaluate(Object wizz) {
            String id = ((WorkspaceWizard)wizz).getId();
            return !this.wizardIds.contains(id);
        }
    }

    private static final class BelongsToList
    implements Predicate {
        private Collection<String> wizardIds;

        public BelongsToList(Collection<String> wizardIds) {
            this.wizardIds = wizardIds;
        }

        public boolean evaluate(Object wizz) {
            String id = ((WorkspaceWizard)wizz).getId();
            return this.wizardIds.contains(id);
        }
    }
}

