/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.viewmapper;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.squashtest.tm.web.internal.model.viewmapper.AttributeMapping;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.SimpleMapping;

public class DefaultDatatableMapper<KEY>
implements DatatableMapper<KEY> {
    private Map<KEY, DatatableMapper.Mapping> mappings;

    public DefaultDatatableMapper() {
        this.mappings = new LinkedHashMap<KEY, DatatableMapper.Mapping>();
    }

    public DefaultDatatableMapper(int initialCapacity) {
        this.mappings = new LinkedHashMap<KEY, DatatableMapper.Mapping>(initialCapacity);
    }

    @Override
    public DatatableMapper<KEY> map(KEY key, DatatableMapper.Mapping mapping) {
        this.mappings.put(key, mapping);
        return this;
    }

    @Override
    public DatatableMapper<KEY> map(KEY key, String expression) {
        this.mappings.put(key, new SimpleMapping(expression));
        return this;
    }

    @Override
    public DatatableMapper<KEY> mapAttribute(KEY key, String attribute, Class<?> ownerType) {
        AttributeMapping register = new AttributeMapping(attribute, ownerType);
        this.mappings.put(key, register);
        return this;
    }

    @Override
    public String getMapping(KEY key) {
        DatatableMapper.Mapping mapping = this.mappings.get(key);
        if (mapping != null) {
            return mapping.getMapping();
        }
        throw new NoSuchElementException("column '" + key + "' is not mapped");
    }

    @Override
    public List<KEY> getMappedKeys() {
        return new ArrayList<KEY>(this.mappings.keySet());
    }
}

