/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.testautomation;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.testautomation.model.TestAutomationProjectContent;
import org.squashtest.tm.web.internal.model.testautomation.TATestNode;

public class TATestNodeListBuilder {
    public Collection<TATestNode> build(Collection<TestAutomationProjectContent> projectContents) {
        LinkedList<TATestNode> nodeList = new LinkedList<TATestNode>();
        for (TestAutomationProjectContent content : projectContents) {
            TATestNode projectNode = this.createProjectNode(content);
            for (AutomatedTest test : content.getTests()) {
                this.merge(projectNode, test);
            }
            nodeList.add(projectNode);
        }
        return nodeList;
    }

    private void merge(TATestNode projectNode, AutomatedTest test) {
        String[] pathArray = test.getName().trim().split("\\/");
        List<String> path = Arrays.asList(pathArray);
        if (path.isEmpty()) {
            return;
        }
        TATestNode parent = projectNode;
        ListIterator<String> iterator = path.listIterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            TATestNode current = parent.findChild(name);
            if (current == null) {
                current = iterator.hasNext() ? this.createFolderNode(name) : this.createTestNode(name);
                parent.getChildren().add(current);
            }
            parent = current;
        }
    }

    private TATestNode createTestNode(String name) {
        TATestNode node = new TATestNode();
        node.setState(JsTreeNode.State.leaf);
        TATestNode.Attr attr = new TATestNode.Attr();
        TATestNode.Data data = new TATestNode.Data();
        attr.setRel("ta-test");
        attr.setRestype("ta-test");
        attr.setName(name);
        data.setTitle(name);
        node.setAttr(attr);
        node.setData(data);
        return node;
    }

    private TATestNode createFolderNode(String name) {
        return this.createFolderNode(name, true);
    }

    private TATestNode createFolderNode(String name, boolean hasChildren) {
        TATestNode node = new TATestNode();
        JsTreeNode.State state = hasChildren ? JsTreeNode.State.closed : JsTreeNode.State.leaf;
        node.setState(state);
        TATestNode.Attr attr = new TATestNode.Attr();
        TATestNode.Data data = new TATestNode.Data();
        attr.setRel("folder");
        attr.setRestype("ta-folder");
        attr.setName(name);
        data.setTitle(name);
        node.setAttr(attr);
        node.setData(data);
        return node;
    }

    private TATestNode createProjectNode(TestAutomationProjectContent content) {
        TestAutomationProject project = content.getProject();
        TATestNode node = new TATestNode();
        JsTreeNode.State state = content.getTests().isEmpty() ? JsTreeNode.State.leaf : JsTreeNode.State.closed;
        node.setState(state);
        TATestNode.Attr attr = new TATestNode.Attr();
        TATestNode.Data data = new TATestNode.Data();
        attr.setId(project.getId().toString());
        attr.setRel("drive");
        attr.setName(project.getLabel());
        attr.setRestype("ta-project");
        data.setTitle(project.getLabel());
        node.setAttr(attr);
        node.setData(data);
        return node;
    }
}

