/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.service.internal.dto.CustomFieldModelFactory;
import org.squashtest.tm.service.internal.dto.CustomFieldValueModel;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

public class CleanCustomFieldValueSerializer
extends JsonSerializer<String> {
    public void serialize(String s, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        Object target = jsonGenerator.getCurrentValue();
        if (CustomFieldValueModel.class.isAssignableFrom(target.getClass())) {
            CustomFieldValueModel model = (CustomFieldValueModel)target;
            String input = model.getBinding().getCustomField().getInputType().getEnumName();
            s = this.cleanCustomFieldValue(s, input);
        } else if (CustomFieldModelFactory.SingleValuedCustomFieldModel.class.isAssignableFrom(target.getClass())) {
            CustomFieldModelFactory.SingleValuedCustomFieldModel model = (CustomFieldModelFactory.SingleValuedCustomFieldModel)target;
            String input = model.getInputType().getEnumName();
            s = this.cleanCustomFieldValue(s, input);
        }
        jsonGenerator.writeString(s);
    }

    public String cleanCustomFieldValue(String s, String input) {
        if (input.equals(InputType.RICH_TEXT.name())) {
            String valueModel = HtmlUtils.htmlUnescape((String)s);
            s = HTMLCleanupUtils.cleanHtml(valueModel);
            s = HTMLCleanupUtils.cleanHtml(s);
        } else if (input.equals(InputType.PLAIN_TEXT.name())) {
            String valueModel = HtmlUtils.htmlUnescape((String)s);
            s = HTMLCleanupUtils.stripJavascript(valueModel);
            s = HTMLCleanupUtils.stripJavascript(s);
        } else {
            String valueModel = HtmlUtils.htmlUnescape((String)s);
            valueModel = HtmlUtils.htmlEscape((String)valueModel);
            s = HtmlUtils.htmlUnescape((String)valueModel);
        }
        return s;
    }
}

