/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.search;

import java.util.Collection;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCase;

public class ExpandedTestCase {
    private TestCase testCase;
    private RequirementCriticality criticality;
    private Collection<RequirementCriticality> selectedCriticalities;

    public String getClassSimpleName() {
        return this.testCase.getClassSimpleName();
    }

    public void setTestCase(TestCase pTestCase) {
        this.testCase = pTestCase;
        this.criticality = this.calculateMaxCriticality();
    }

    public String getName() {
        return this.testCase.getName();
    }

    public String getReference() {
        return this.testCase.getReference();
    }

    public Project getProject() {
        return this.testCase.getProject();
    }

    public Long getId() {
        return this.testCase.getId();
    }

    public RequirementCriticality getCriticality() {
        return this.criticality;
    }

    public void setSelectedCriticalities(Collection<RequirementCriticality> pSelectedCriticalities) {
        this.selectedCriticalities = pSelectedCriticalities;
    }

    private RequirementCriticality calculateMaxCriticality() {
        int level = 3;
        for (RequirementVersion requirement : this.testCase.getVerifiedRequirementVersions()) {
            if (requirement.getCriticality().getLevel() >= level || !this.selectedCriticalities.isEmpty() && !this.selectedCriticalities.contains(requirement.getCriticality())) continue;
            level = requirement.getCriticality().getLevel();
        }
        return RequirementCriticality.valueOf((int)level);
    }
}

