/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.rest;

import java.util.Date;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.web.internal.model.rest.RestCampaignStub;
import org.squashtest.tm.web.internal.model.rest.RestIterationStub;
import org.squashtest.tm.web.internal.model.rest.RestProject;
import org.squashtest.tm.web.internal.model.rest.RestTestCaseStub;

public class RestExecution {
    private Long id;
    private String reference;
    private String name;
    private RestProject project;
    private String testcasePath;
    private String description;
    private RestCampaignStub restCampaignStub;
    private RestIterationStub restIterationStub;
    private RestTestCaseStub restTestCaseStub;
    private String status;
    private String lastExecutedOn;
    private String lastExecutedBy;

    public RestExecution() {
    }

    public RestExecution(Execution execution, String testcasePath) {
        this.id = execution.getId();
        this.reference = execution.getReference();
        this.name = execution.getName();
        this.project = new RestProject(execution.getProject());
        this.testcasePath = testcasePath;
        this.description = execution.getTcdescription();
        this.restCampaignStub = new RestCampaignStub(execution.getCampaign());
        this.restIterationStub = new RestIterationStub(execution.getIteration());
        this.restTestCaseStub = new RestTestCaseStub(execution.getReferencedTestCase());
        this.status = execution.getExecutionStatus().name();
        this.lastExecutedOn = DateUtils.formatIso8601DateTime((Date)execution.getLastExecutedOn());
        this.lastExecutedBy = execution.getLastExecutedBy();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public RestCampaignStub getRestCampaignStub() {
        return this.restCampaignStub;
    }

    public void setRestCampaignStub(RestCampaignStub restCampaignStub) {
        this.restCampaignStub = restCampaignStub;
    }

    public RestIterationStub getRestIterationStub() {
        return this.restIterationStub;
    }

    public void setRestIterationStub(RestIterationStub restIterationStub) {
        this.restIterationStub = restIterationStub;
    }

    public RestTestCaseStub getRestTestCaseStub() {
        return this.restTestCaseStub;
    }

    public void setRestTestCaseStub(RestTestCaseStub restTestCaseStub) {
        this.restTestCaseStub = restTestCaseStub;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RestProject getProject() {
        return this.project;
    }

    public void setProject(RestProject project) {
        this.project = project;
    }

    public String getTestcasePath() {
        return this.testcasePath;
    }

    public void setTestcasePath(String testcasePath) {
        this.testcasePath = testcasePath;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLastExecutedOn() {
        return this.lastExecutedOn;
    }

    public void setLastExecutedOn(Date lastExecutedOn) {
        this.lastExecutedOn = DateUtils.formatIso8601DateTime((Date)lastExecutedOn);
    }

    public String getLastExecutedBy() {
        return this.lastExecutedBy;
    }

    public void setLastExecutedBy(String lastExecutedBy) {
        this.lastExecutedBy = lastExecutedBy;
    }
}

