/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.LevelComparator;

public class LevelEnumSerializer
extends JsonSerializer<EnumSet<? extends Level>> {
    public void serialize(EnumSet<? extends Level> enumSet, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        List<Level> levels = Arrays.asList(enumSet.toArray(new Level[enumSet.size()]));
        Collections.sort(levels, LevelComparator.getInstance());
        jgen.writeStartArray();
        for (Level lv : levels) {
            jgen.writeStartObject();
            jgen.writeStringField("name", ((Enum)lv).name());
            jgen.writeNumberField("level", lv.getLevel());
            jgen.writeStringField("i18nkey", lv.getI18nKey());
            jgen.writeEndObject();
        }
        jgen.writeEndArray();
    }
}

