/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.JsonProjectBuilder;
import org.squashtest.tm.web.internal.model.json.JsonInternationalizableItem;
import org.squashtest.tm.web.internal.model.json.JsonTestCase;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Component
@Scope(value="prototype")
public class JsonTestCaseBuilder {
    @Inject
    private InternationalizationHelper internationalizationHelper;
    @Inject
    private JsonProjectBuilder projectBuilder;
    private Locale locale;
    private List<TestCase> entities;
    private boolean extended = false;

    public JsonTestCaseBuilder locale(@NotNull Locale locale) {
        this.locale = locale;
        return this;
    }

    public ListBuilder entities(@NotNull List<TestCase> entities) {
        this.entities = entities;
        return new ListBuilder(){

            @Override
            public List<JsonTestCase> toJson() {
                return JsonTestCaseBuilder.this.buildList();
            }
        };
    }

    public JsonTestCaseBuilder extended() {
        this.extended = true;
        return this;
    }

    private List<JsonTestCase> buildList() {
        if (this.entities.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JsonTestCase> res = new ArrayList<JsonTestCase>(this.entities.size());
        for (TestCase tc : this.entities) {
            res.add(this.build(tc));
        }
        return res;
    }

    private JsonTestCase build(TestCase tc) {
        JsonTestCase res = new JsonTestCase();
        res.setId(tc.getId());
        res.setName(HtmlUtils.htmlEscape((String)tc.getName()));
        res.setRef(HtmlUtils.htmlEscape((String)tc.getReference()));
        res.setProject(this.projectBuilder.toSimpleJson(tc.getProject()));
        res.setType(this.buildType(tc.getType()));
        if (this.extended) {
            res.setDescription(HTMLCleanupUtils.cleanHtml(tc.getDescription()));
        }
        return res;
    }

    private JsonInternationalizableItem buildType(InfoListItem type) {
        JsonInternationalizableItem res = new JsonInternationalizableItem();
        res.setValue(type.getCode());
        res.setLabel(this.internationalizationHelper.getMessage(type.getLabel(), null, type.getLabel(), this.locale));
        return res;
    }

    public static interface ListBuilder {
        public List<JsonTestCase> toJson();
    }
}

