/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.json;

import java.util.Date;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.users.User;

public class JsonIterationTestPlanItem {
    private long id;
    private ExecutionStatus executionStatus;
    private String name;
    private String lastExecutedOn;
    private String lastExecutedBy;
    private String assignee;
    private boolean isTestCaseDeleted;
    private boolean isAutomated;

    public JsonIterationTestPlanItem(long id, ExecutionStatus executionStatus, String name, String lastExecutedOn, String lastExecutedBy, String assignee, boolean isTestCaseDeleted, boolean isAutomated) {
        this.id = id;
        this.executionStatus = executionStatus;
        this.name = name;
        this.lastExecutedOn = lastExecutedOn;
        this.lastExecutedBy = lastExecutedBy;
        this.assignee = assignee;
        this.isTestCaseDeleted = isTestCaseDeleted;
        this.isAutomated = isAutomated;
    }

    public JsonIterationTestPlanItem(long id, ExecutionStatus executionStatus, String name, Date lastExecutedOn, String lastExecutedBy, User assignee, boolean isTestCaseDeleted, boolean isAutomated) {
        this.id = id;
        this.executionStatus = executionStatus;
        this.name = name;
        this.lastExecutedOn = this.toISO8601(lastExecutedOn);
        this.lastExecutedBy = lastExecutedBy;
        this.assignee = assignee != null ? assignee.getLogin() : "";
        this.isTestCaseDeleted = isTestCaseDeleted;
        this.isAutomated = isAutomated;
    }

    private String toISO8601(Date date) {
        return DateUtils.formatIso8601DateTime((Date)date);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLastExecutedOn() {
        return this.lastExecutedOn;
    }

    public void setLastExecutedOn(String lastExecutedOn) {
        this.lastExecutedOn = lastExecutedOn;
    }

    public String getLastExecutedBy() {
        return this.lastExecutedBy;
    }

    public void setLastExecutedBy(String lastExecutedBy) {
        this.lastExecutedBy = lastExecutedBy;
    }

    public boolean isTestCaseDeleted() {
        return this.isTestCaseDeleted;
    }

    public void setTestCaseDeleted(boolean isTestCaseDeleted) {
        this.isTestCaseDeleted = isTestCaseDeleted;
    }

    public boolean isAutomated() {
        return this.isAutomated;
    }

    public void setAutomated(boolean isAutomated) {
        this.isAutomated = isAutomated;
    }

    public void setAssignee(String login) {
        this.assignee = login;
    }

    public String getAssignee() {
        return this.assignee;
    }
}

