/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.json;

import java.util.Date;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.audit.AuditableMixin;

public class JsonGeneralInfo {
    private String createdOn;
    private String createdBy;
    private String modifiedOn;
    private String modifiedBy;

    public JsonGeneralInfo(String createdOn, String createdBy, String modifiedOn, String modifiedBy) {
        this.createdOn = createdOn;
        this.createdBy = createdBy;
        this.modifiedOn = modifiedOn;
        this.modifiedBy = modifiedBy;
    }

    public JsonGeneralInfo(Date createdOn, String createdBy, Date modifiedOn, String modifedBy) {
        this.createdOn = DateUtils.formatIso8601DateTime((Date)createdOn);
        this.createdBy = createdBy;
        this.modifiedOn = DateUtils.formatIso8601DateTime((Date)modifiedOn);
        this.modifiedBy = modifedBy;
    }

    public JsonGeneralInfo(AuditableMixin mixin) {
        this.createdOn = DateUtils.formatIso8601DateTime((Date)mixin.getCreatedOn());
        this.createdBy = HtmlUtils.htmlEscape((String)mixin.getCreatedBy());
        this.modifiedOn = DateUtils.formatIso8601DateTime((Date)mixin.getLastModifiedOn());
        if (mixin.getLastModifiedBy() != null) {
            this.modifiedBy = HtmlUtils.htmlEscape((String)mixin.getLastModifiedBy());
        }
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getModifiedOn() {
        return this.modifiedOn;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }
}

