/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.json;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.chart.ChartType;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.query.ColumnRole;
import org.squashtest.tm.domain.query.DataType;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.service.customfield.CustomFieldBindingModificationService;
import org.squashtest.tm.service.infolist.InfoListFinderService;
import org.squashtest.tm.web.internal.model.json.LevelEnumSerializer;

public class JsonChartWizardData {
    private Map<EntityType, Set<QueryColumnPrototype>> columnPrototypes;
    private EnumSet<ChartType> chartTypes = EnumSet.allOf(ChartType.class);
    private Map<ColumnRole, EnumSet<Operation>> columnRoles = new EnumMap<ColumnRole, EnumSet<Operation>>(ColumnRole.class);
    private Map<DataType, EnumSet<Operation>> dataTypes = new EnumMap<DataType, EnumSet<Operation>>(DataType.class);
    private Map<EntityType, String> entityTypes = new LinkedHashMap<EntityType, String>();
    private Map<String, EnumSet<? extends Level>> levelEnums = new HashMap<String, EnumSet<? extends Level>>();
    private EnumSet<ExecutionStatus> executionStatus = EnumSet.allOf(ExecutionStatus.class);
    private EnumSet<ExecutionStatus> itpiExecutionStatus = EnumSet.complementOf(EnumSet.copyOf(ExecutionStatus.TA_STATUSES_ONLY));
    private Map<String, Map<String, InfoList>> projectInfoList = new HashMap<String, Map<String, InfoList>>();
    private Map<String, Set<CustomField>> customFields = new HashMap<String, Set<CustomField>>();
    private InfoListFinderService infoListFinder;
    private CustomFieldBindingModificationService cufBindingService;
    private Map<Long, Set<ExecutionStatus>> disabledStatusByProject = new HashMap<Long, Set<ExecutionStatus>>();

    public JsonChartWizardData(Map<EntityType, Set<QueryColumnPrototype>> columnPrototypes, List<Project> projects, InfoListFinderService infoListFinder, CustomFieldBindingModificationService cufBindingService) {
        this.columnPrototypes = columnPrototypes;
        this.infoListFinder = infoListFinder;
        this.cufBindingService = cufBindingService;
        this.populate(projects);
    }

    private void populate(List<Project> projects) {
        this.addColumnRoles();
        this.addDataType();
        this.addLevelEnums();
        this.addEntityType();
        this.addInfoList(projects);
        this.addDisabledStatus(projects);
    }

    private void addDisabledStatus(List<Project> projects) {
        for (Project project : projects) {
            this.disabledStatusByProject.put(project.getId(), project.getCampaignLibrary().getDisabledStatuses());
        }
    }

    private void addLevelEnums() {
        this.addLevelEnum("TEST_CASE_STATUS", TestCaseStatus.class);
        this.addLevelEnum("test-case-execution-mode", TestCaseExecutionMode.class);
        this.addLevelEnum("TEST_CASE_IMPORTANCE", TestCaseImportance.class);
        this.addLevelEnum("REQUIREMENT_VERSION_CRITICALITY", RequirementCriticality.class);
        this.addLevelEnum("REQUIREMENT_VERSION_STATUS", RequirementStatus.class);
        this.addLevelEnum("REQUIREMENT_CRITICALITY", RequirementCriticality.class);
        this.addLevelEnum("REQUIREMENT_STATUS", RequirementStatus.class);
    }

    private void addColumnRoles() {
        ColumnRole[] columnRoleArray = ColumnRole.values();
        int n = columnRoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnRole cr = columnRoleArray[n2];
            this.columnRoles.put(cr, (EnumSet)cr.getOperations());
            ++n2;
        }
    }

    private void addDataType() {
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType dt = dataTypeArray[n2];
            this.dataTypes.put(dt, (EnumSet)dt.getOperations());
            ++n2;
        }
    }

    private void addEntityType() {
        this.entityTypes.put(EntityType.REQUIREMENT, "icon-chart-requirement");
        this.entityTypes.put(EntityType.REQUIREMENT_VERSION, "icon-chart-requirement-version");
        this.entityTypes.put(EntityType.TEST_CASE, "icon-chart-test-case");
        this.entityTypes.put(EntityType.CAMPAIGN, "icon-chart-campaign");
        this.entityTypes.put(EntityType.ITERATION, "icon-chart-iteration");
        this.entityTypes.put(EntityType.ITEM_TEST_PLAN, "icon-chart-item-test-plan");
        this.entityTypes.put(EntityType.EXECUTION, "icon-chart-execution");
    }

    private void addInfoList(List<Project> projects) {
        for (Project project : projects) {
            HashMap<String, InfoList> infoLists = new HashMap<String, InfoList>();
            infoLists.put("REQUIREMENT_VERSION_CATEGORY", project.getRequirementCategories());
            infoLists.put("REQUIREMENT_CATEGORY", project.getRequirementCategories());
            infoLists.put("TEST_CASE_NATURE", project.getTestCaseNatures());
            infoLists.put("TEST_CASE_TYPE", project.getTestCaseTypes());
            this.projectInfoList.put(project.getId().toString(), infoLists);
        }
        HashMap<String, InfoList> defaultList = new HashMap<String, InfoList>();
        defaultList.put("REQUIREMENT_VERSION_CATEGORY", this.infoListFinder.findByCode(SystemInfoListCode.REQUIREMENT_CATEGORY.getCode()));
        defaultList.put("REQUIREMENT_CATEGORY", this.infoListFinder.findByCode(SystemInfoListCode.REQUIREMENT_CATEGORY.getCode()));
        defaultList.put("TEST_CASE_NATURE", this.infoListFinder.findByCode(SystemInfoListCode.TEST_CASE_NATURE.getCode()));
        defaultList.put("TEST_CASE_TYPE", this.infoListFinder.findByCode(SystemInfoListCode.TEST_CASE_TYPE.getCode()));
        this.projectInfoList.put("default", defaultList);
    }

    private void addCustomFields(List<Project> projects) {
        for (Project project : projects) {
            List cufBindings = this.cufBindingService.findCustomFieldsForGenericProject(project.getId().longValue());
            List cufs = (List)CollectionUtils.collect((Collection)cufBindings, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return ((CustomFieldBinding)input).getCustomField();
                }
            });
            this.customFields.put(project.getId().toString(), new HashSet(cufs));
        }
    }

    private <E extends Enum<E>> void addLevelEnum(String name, Class<E> clazz) {
        this.levelEnums.put(name, EnumSet.allOf(clazz));
    }

    public Map<EntityType, Set<QueryColumnPrototype>> getColumnPrototypes() {
        return this.columnPrototypes;
    }

    public Set<ChartType> getChartTypes() {
        return this.chartTypes;
    }

    public Map<EntityType, String> getEntityTypes() {
        return this.entityTypes;
    }

    public Map<ColumnRole, EnumSet<Operation>> getcolumnRoles() {
        return this.columnRoles;
    }

    public Map<DataType, EnumSet<Operation>> getDataTypes() {
        return this.dataTypes;
    }

    public Map<String, Map<String, InfoList>> getProjectInfoList() {
        return this.projectInfoList;
    }

    public Map<String, Set<CustomField>> getCustomFields() {
        return this.customFields;
    }

    @JsonSerialize(contentUsing=LevelEnumSerializer.class)
    public Map<String, EnumSet<? extends Level>> getLevelEnums() {
        return this.levelEnums;
    }

    @JsonSerialize(using=LevelEnumSerializer.class)
    public Set<ExecutionStatus> getExecutionStatus() {
        return this.executionStatus;
    }

    public Map<Long, Set<ExecutionStatus>> getDisabledStatusByProject() {
        return this.disabledStatusByProject;
    }

    @JsonSerialize(using=LevelEnumSerializer.class)
    public Set<ExecutionStatus> getItpiExecutionStatus() {
        return this.itpiExecutionStatus;
    }
}

