/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.json;

import java.util.Locale;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.json.JsonRemoteAutomationRequestExtender;

public class JsonAutomationRequest {
    private Locale locale;
    private InternationalizationHelper i18nHelper;
    private String requestStatus;
    private String transmissionDate;
    private Integer automationPriority;
    private JsonRemoteAutomationRequestExtender remoteAutomationRequestExtender;

    public JsonAutomationRequest(AutomationRequest automationRequest, InternationalizationHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
        this.requestStatus = i18nHelper.internationalize(automationRequest.getRequestStatus().getI18nKey(), this.locale);
        this.transmissionDate = i18nHelper.localizeDate(automationRequest.getTransmissionDate(), this.locale);
        this.automationPriority = automationRequest.getAutomationPriority();
        this.remoteAutomationRequestExtender = new JsonRemoteAutomationRequestExtender(automationRequest.getRemoteAutomationRequestExtender());
    }

    public String getRequestStatus() {
        return this.requestStatus;
    }

    public void setRequestStatus(String requestStatus) {
        this.requestStatus = requestStatus;
    }

    public String getTransmissionDate() {
        return this.transmissionDate;
    }

    public void setTransmissionDate(String transmissionDate) {
        this.transmissionDate = transmissionDate;
    }

    public Integer getAutomationPriority() {
        return this.automationPriority;
    }

    public void setAutomationPriority(Integer automationPriority) {
        this.automationPriority = automationPriority;
    }

    public JsonRemoteAutomationRequestExtender getRemoteAutomationRequestExtender() {
        return this.remoteAutomationRequestExtender;
    }

    public void setRemoteAutomationRequestExtender(JsonRemoteAutomationRequestExtender remoteAutomationRequestExtender) {
        this.remoteAutomationRequestExtender = remoteAutomationRequestExtender;
    }
}

