/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.datatable;

import java.util.ArrayList;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;

public final class SpringPagination {
    private SpringPagination() {
    }

    public static Pageable pageable(DataTableDrawParameters dtParams) {
        PageNumSize pns = SpringPagination.createPageNumSize(dtParams);
        return PageRequest.of((int)pns.pagenum, (int)pns.pagesize);
    }

    public static Pageable pageable(DataTableDrawParameters dtParams, DatatableMapper mapper) {
        PageNumSize pns = SpringPagination.createPageNumSize(dtParams);
        Sort sort = SpringPagination.createSort(dtParams, mapper, key -> mapper.getMapping(key));
        return PageRequest.of((int)pns.pagenum, (int)pns.pagesize, (Sort)sort);
    }

    public static <KEY> Pageable pageable(DataTableDrawParameters dtParams, DatatableMapper mapper, SortedAttributeNameSupplier<KEY> attrNameSupplier) {
        PageNumSize pns = SpringPagination.createPageNumSize(dtParams);
        Sort sort = SpringPagination.createSort(dtParams, mapper, attrNameSupplier);
        return PageRequest.of((int)pns.pagenum, (int)pns.pagesize, (Sort)sort);
    }

    private static PageNumSize createPageNumSize(DataTableDrawParameters dtParams) {
        int pagesize = Integer.MAX_VALUE;
        int pagenum = 0;
        if (dtParams.getiDisplayLength() > 0) {
            pagesize = dtParams.getiDisplayLength();
            pagenum = dtParams.getiDisplayStart() / pagesize;
        }
        return new PageNumSize(pagenum, pagesize);
    }

    private static <KEY> Sort createSort(DataTableDrawParameters dtParams, DatatableMapper mapper, SortedAttributeNameSupplier<KEY> attrNameSupplier) {
        Sort sort = null;
        int howMany = dtParams.getiSortingCols();
        if (howMany > 0) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>(howMany);
            int i = 0;
            while (i < howMany) {
                int sortedcol = dtParams.getiSortCol(i);
                Object mappingkey = dtParams.getmDataProp(sortedcol);
                String attribute = attrNameSupplier.getAttributeName(mappingkey);
                String sorteddir = dtParams.getsSortDir(i);
                Sort.Direction direction = "asc".equals(sorteddir) ? Sort.Direction.ASC : Sort.Direction.DESC;
                orders.add(new Sort.Order(direction, attribute));
                ++i;
            }
            sort = Sort.by(orders);
        }
        return sort;
    }

    private static final class PageNumSize {
        int pagenum;
        int pagesize;

        PageNumSize(int pagenum, int pagesize) {
            this.pagenum = pagenum;
            this.pagesize = pagesize;
        }
    }

    public static interface SortedAttributeNameSupplier<KEY> {
        public String getAttributeName(KEY var1);
    }
}

