/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.datatable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Page;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;

public abstract class DataTableModelBuilder<X> {
    private long currentIndex = 0L;

    public final DataTableModel buildDataModel(Page<X> page, String sEcho) {
        this.currentIndex = (long)page.getNumber() * (long)page.getSize() + 1L;
        DataTableModel model = this.createModelFromItems(sEcho, page.getContent());
        model.displayRowsFromTotalOf(page.getTotalElements());
        return model;
    }

    public final DataTableModel buildDataModel(PagedCollectionHolder<List<X>> holder, String sEcho) {
        this.currentIndex = holder.getFirstItemIndex() + 1L;
        DataTableModel model = this.createModelFromItems(sEcho, holder.getPagedItems());
        model.displayRowsFromTotalOf(holder.getTotalNumberOfItems());
        return model;
    }

    public final Collection<Object> buildRawModel(Page<X> page) {
        this.currentIndex = (long)page.getNumber() * (long)page.getSize() + 1L;
        return this.buildRawModel(page.getContent());
    }

    public final Collection<Object> buildRawModel(PagedCollectionHolder<List<X>> holder) {
        this.currentIndex = holder.getFirstItemIndex() + 1L;
        return this.buildRawModel(holder.getPagedItems());
    }

    public List<Object> buildRawModel(Collection<X> pagedItems) {
        ArrayList<Object> model = new ArrayList<Object>(pagedItems.size());
        for (X item : pagedItems) {
            Object itemData = this.buildItemData(item);
            model.add(itemData);
            ++this.currentIndex;
        }
        return model;
    }

    public List<Object> buildRawModel(Collection<X> pagedItems, int startIndex) {
        this.currentIndex = startIndex;
        return this.buildRawModel(pagedItems);
    }

    private DataTableModel createModelFromItems(String sEcho, Collection<X> pagedItems) {
        DataTableModel<Object> model = new DataTableModel<Object>(sEcho);
        for (X item : pagedItems) {
            model.addRow(this.buildItemData(item));
            ++this.currentIndex;
        }
        return model;
    }

    protected final long getCurrentIndex() {
        return this.currentIndex;
    }

    protected static String formatUsername(String username) {
        if (username == null || username.trim().isEmpty()) {
            return "-";
        }
        return username;
    }

    private void setCurrentIndex(int i) {
    }

    protected abstract Object buildItemData(X var1);
}

