/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.datatable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;

public class DataTableColumnFiltering
implements ColumnFiltering {
    private final DataTableDrawParameters params;
    private Map<Object, Integer> dataProps = new HashMap<Object, Integer>();
    private DatatableMapper mapper;

    public DataTableColumnFiltering(DataTableDrawParameters params) {
        this.params = params;
        this.createDataProps();
    }

    public DataTableColumnFiltering(DataTableDrawParameters params, DatatableMapper mapper) {
        this.params = params;
        this.mapper = mapper;
        this.createDataPropsAutomation();
    }

    private void createDataProps() {
        Map<Integer, Object> mDataProp = this.params.getmDataProp();
        for (Map.Entry<Integer, Object> entry : mDataProp.entrySet()) {
            this.dataProps.put(entry.getValue(), entry.getKey());
        }
    }

    private void createDataPropsAutomation() {
        Set<Map.Entry<Integer, Object>> entries = this.params.getmDataProp().entrySet();
        for (Map.Entry<Integer, Object> entry : entries) {
            if ("tc-id".equals(entry.getValue()) || "checkbox".equals(entry.getValue()) || "writable".equals(entry.getValue()) || "writableAutom".equals(entry.getValue())) continue;
            this.dataProps.put(this.mapper.getMapping(entry.getValue()), entry.getKey());
        }
    }

    public List<String> getFilteredAttributes() {
        ArrayList<String> attributes = new ArrayList();
        if (this.mapper != null) {
            Set<Map.Entry<Integer, String>> entries = this.params.getsSearches().entrySet();
            int x = 0;
            while (x < entries.size()) {
                if (!StringUtils.isBlank((CharSequence)this.params.getsSearches(x))) {
                    Object mDataIndex = this.params.getmDataProp(x);
                    attributes.add(this.mapper.getMapping(mDataIndex));
                }
                ++x;
            }
        } else {
            attributes = this.params.getsSearches().values().stream().filter(s -> !StringUtils.isBlank((CharSequence)s)).collect(Collectors.toList());
        }
        return attributes;
    }

    public boolean isDefined() {
        return !this.getFilteredAttributes().isEmpty();
    }

    public String getFilter(String mDataProp) {
        Integer index = this.indexOf(mDataProp);
        return this.params.getsSearches(index);
    }

    public boolean hasFilter(String mDataProp) {
        if (this.dataProps.containsKey(mDataProp)) {
            String filter = this.getFilter(mDataProp);
            return !StringUtils.isBlank((CharSequence)filter);
        }
        return false;
    }

    private Integer indexOf(String prop) {
        return this.dataProps.get(prop);
    }
}

