/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.util.Locale;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.exception.execution.EmptyTestSuiteTestPlanException;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.GenericJsTreeNodeBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Component
@Scope(value="prototype")
public class TestSuiteNodeBuilder
extends GenericJsTreeNodeBuilder<TestSuite, TestSuiteNodeBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestSuiteNodeBuilder.class);
    protected InternationalizationHelper internationalizationHelper;

    @Inject
    protected TestSuiteNodeBuilder(PermissionEvaluationService permissionEvaluationService, InternationalizationHelper internationalizationHelper) {
        super(permissionEvaluationService);
        this.internationalizationHelper = internationalizationHelper;
    }

    @Override
    protected JsTreeNode doBuild(JsTreeNode node, TestSuite model) {
        node.addAttr("rel", "test-suite");
        node.addAttr("resId", String.valueOf(model.getId()));
        node.addAttr("resType", "test-suites");
        node.setState(JsTreeNode.State.leaf);
        node.setTitle(HtmlUtils.htmlEscape((String)model.getName()));
        node.addAttr("name", HtmlUtils.htmlEscape((String)model.getName()));
        node.addAttr("id", String.valueOf(model.getClass().getSimpleName()) + '-' + model.getId());
        node.addAttr("executionStatus", model.getExecutionStatus().toString());
        String status = model.getExecutionStatus().getI18nKey();
        Locale locale = LocaleContextHolder.getLocale();
        String localizedStatus = this.internationalizationHelper.internationalize(status, locale);
        Object[] args = new String[]{localizedStatus};
        String tooltip = this.internationalizationHelper.getMessage("label.tree.testSuite.tooltip", args, status, locale);
        String description = "";
        try {
            if (model.getFirstPlannedTestCase() != null && StringUtils.isNotBlank((String)model.getFirstPlannedTestCase().getDescription()) && (description = HTMLCleanupUtils.htmlToText(HtmlUtils.htmlEscape((String)model.getFirstPlannedTestCase().getDescription()))).length() > 30) {
                description = String.valueOf(description.substring(0, 30)) + "...";
            }
        }
        catch (EmptyTestSuiteTestPlanException e) {
            LOGGER.debug("The test plan of this test suite is empty. Setting empty tooltip.", (Throwable)e);
            description = "";
        }
        node.addAttr("title", String.valueOf(tooltip) + "\n" + description);
        node.addAttr("milestones", (Number)model.getMilestones().size());
        node.addAttr("milestone-creatable-deletable", model.doMilestonesAllowCreation().toString());
        node.addAttr("milestone-editable", model.doMilestonesAllowEdition().toString());
        return node;
    }

    @Override
    protected void doAddChildren(JsTreeNode node, TestSuite model) {
    }
}

