/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.core.foundation.lang.Wrapped;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNodeVisitor;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.milestone.MilestoneMembershipFinder;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.JsTreeNodeListBuilder;
import org.squashtest.tm.web.internal.model.builder.LibraryTreeNodeBuilder;

@Component
@Scope(value="prototype")
public class TestCaseLibraryTreeNodeBuilder
extends LibraryTreeNodeBuilder<TestCaseLibraryNode> {
    protected VerifiedRequirementsManagerService verifiedRequirementsManagerService;
    protected InternationalizationHelper internationalizationHelper;
    @Inject
    private MilestoneMembershipFinder milestoneMembershipFinder;

    @Inject
    public TestCaseLibraryTreeNodeBuilder(PermissionEvaluationService permissionEvaluationService, VerifiedRequirementsManagerService verifiedRequirementsManagerService, InternationalizationHelper internationalizationHelper) {
        super(permissionEvaluationService);
        this.verifiedRequirementsManagerService = verifiedRequirementsManagerService;
        this.internationalizationHelper = internationalizationHelper;
    }

    public void setMilestoneMembershipFinder(MilestoneMembershipFinder finder) {
        this.milestoneMembershipFinder = finder;
    }

    @Override
    protected void addCustomAttributes(TestCaseLibraryNode libraryNode, JsTreeNode treeNode) {
        libraryNode.accept((TestCaseLibraryNodeVisitor)new CustomAttributesPopulator(treeNode));
    }

    @Override
    protected void doAddChildren(JsTreeNode node, TestCaseLibraryNode model) {
        model.accept((TestCaseLibraryNodeVisitor)new ChildrenPopulator(node));
    }

    @Override
    protected boolean passesMilestoneFilter() {
        if (this.milestoneFilter != null) {
            return new MilestoneFilter(this.milestoneMembershipFinder, this.milestoneFilter).isValid((TestCaseLibraryNode)this.node);
        }
        return true;
    }

    private class ChildrenPopulator
    implements TestCaseLibraryNodeVisitor {
        private final JsTreeNode builtNode;

        public ChildrenPopulator(JsTreeNode builtNode) {
            this.builtNode = builtNode;
        }

        public void visit(TestCase visited) {
        }

        public void visit(TestCaseFolder visited) {
            if (visited.hasContent()) {
                TestCaseLibraryTreeNodeBuilder childrenBuilder = new TestCaseLibraryTreeNodeBuilder(TestCaseLibraryTreeNodeBuilder.this.permissionEvaluationService, TestCaseLibraryTreeNodeBuilder.this.verifiedRequirementsManagerService, TestCaseLibraryTreeNodeBuilder.this.internationalizationHelper);
                childrenBuilder.setMilestoneMembershipFinder(TestCaseLibraryTreeNodeBuilder.this.milestoneMembershipFinder);
                childrenBuilder.filterByMilestone(TestCaseLibraryTreeNodeBuilder.this.milestoneFilter);
                List<JsTreeNode> children = new JsTreeNodeListBuilder<TestCaseLibraryNode>(childrenBuilder).expand(TestCaseLibraryTreeNodeBuilder.this.getExpansionCandidates()).setModel(visited.getOrderedContent()).build();
                this.builtNode.setChildren(children);
                JsTreeNode.State state = children.isEmpty() ? JsTreeNode.State.leaf : JsTreeNode.State.open;
                this.builtNode.setState(state);
            }
        }
    }

    private class CustomAttributesPopulator
    implements TestCaseLibraryNodeVisitor {
        private final JsTreeNode builtNode;

        public CustomAttributesPopulator(JsTreeNode builtNode) {
            this.builtNode = builtNode;
        }

        public void visit(TestCase visited) {
            TestCaseStatus status = visited.getStatus();
            TestCaseImportance importance = visited.getImportance();
            Boolean isreqcovered = !visited.getRequirementVersionCoverages().isEmpty() || TestCaseLibraryTreeNodeBuilder.this.verifiedRequirementsManagerService.testCaseHasUndirectRequirementCoverage(visited.getId().longValue());
            Boolean hasSteps = !visited.getSteps().isEmpty();
            Locale locale = LocaleContextHolder.getLocale();
            String localizedStatus = TestCaseLibraryTreeNodeBuilder.this.internationalizationHelper.internationalize((Internationalizable)status, locale);
            String localizedImportance = TestCaseLibraryTreeNodeBuilder.this.internationalizationHelper.internationalize((Internationalizable)importance, locale);
            String localizedIsReqCovered = TestCaseLibraryTreeNodeBuilder.this.internationalizationHelper.internationalizeYesNo(isreqcovered, locale);
            String localizedHasSteps = TestCaseLibraryTreeNodeBuilder.this.internationalizationHelper.internationalize("tooltip.tree.testCase.hasSteps." + hasSteps, locale);
            Object[] args = new String[]{localizedStatus, localizedImportance, localizedIsReqCovered, localizedHasSteps};
            String tooltip = TestCaseLibraryTreeNodeBuilder.this.internationalizationHelper.getMessage("label.tree.testCase.tooltip", args, visited.getId().toString(), locale);
            TestCaseLibraryTreeNodeBuilder.this.addLeafAttributes("test-case", "test-cases");
            this.builtNode.addAttr("reference", HtmlUtils.htmlEscape((String)visited.getReference()));
            this.builtNode.setTitle(HtmlUtils.htmlEscape((String)visited.getFullName()));
            this.builtNode.addAttr("status", status.toString().toLowerCase());
            this.builtNode.addAttr("importance", importance.toString().toLowerCase());
            this.builtNode.addAttr("isreqcovered", isreqcovered.toString());
            this.builtNode.addAttr("title", tooltip);
            this.builtNode.addAttr("hassteps", hasSteps.toString());
            final Wrapped testCaseKind = new Wrapped();
            TestCaseVisitor visitor = new TestCaseVisitor(){

                public void visit(TestCase testCase) {
                    testCaseKind.setValue((Object)"standard");
                }

                public void visit(KeywordTestCase keywordTestCase) {
                    testCaseKind.setValue((Object)"keyword");
                }

                public void visit(ScriptedTestCase scriptedTestCase) {
                    testCaseKind.setValue((Object)"gherkin");
                }
            };
            visited.accept(visitor);
            this.builtNode.addAttr("kind", (String)testCaseKind.getValue());
            Collection allMilestones = TestCaseLibraryTreeNodeBuilder.this.milestoneMembershipFinder.findAllMilestonesForTestCase(visited.getId().longValue());
            this.builtNode.addAttr("milestones", (Number)allMilestones.size());
            this.builtNode.addAttr("milestone-creatable-deletable", Milestone.allowsCreationOrDeletion((Collection)allMilestones).toString());
            this.builtNode.addAttr("milestone-editable", Milestone.allowsEdition((Collection)allMilestones).toString());
        }

        public void visit(TestCaseFolder visited) {
            TestCaseLibraryTreeNodeBuilder.this.addFolderAttributes("test-case-folders");
            JsTreeNode.State state = visited.hasContent() ? JsTreeNode.State.closed : JsTreeNode.State.leaf;
            this.builtNode.setState(state);
        }
    }

    private static final class MilestoneFilter
    implements TestCaseLibraryNodeVisitor {
        private MilestoneMembershipFinder memberFinder;
        private Milestone milestone;
        private boolean isValid;

        private MilestoneFilter(MilestoneMembershipFinder memberFinder, Milestone milestone) {
            this.memberFinder = memberFinder;
            this.milestone = milestone;
        }

        public void visit(TestCase visited) {
            Collection allMilestones = this.memberFinder.findAllMilestonesForTestCase(visited.getId().longValue());
            this.isValid = allMilestones.contains(this.milestone);
        }

        public void visit(TestCaseFolder visited) {
            this.isValid = true;
        }

        public boolean isValid(TestCaseLibraryNode node) {
            this.isValid = false;
            node.accept((TestCaseLibraryNodeVisitor)this);
            return this.isValid;
        }
    }
}

