/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementLibraryNodeVisitor;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.model.builder.JsTreeNodeListBuilder;
import org.squashtest.tm.web.internal.model.builder.LibraryTreeNodeBuilder;

@Component
@Scope(value="prototype")
public class RequirementLibraryTreeNodeBuilder
extends LibraryTreeNodeBuilder<RequirementLibraryNode> {
    @Inject
    public RequirementLibraryTreeNodeBuilder(PermissionEvaluationService permissionEvaluationService) {
        super(permissionEvaluationService);
    }

    private int totalMilestones(Requirement requirement) {
        int count = 0;
        for (RequirementVersion v : requirement.getRequirementVersions()) {
            count += v.getMilestones().size();
        }
        return count;
    }

    @Override
    protected void addCustomAttributes(RequirementLibraryNode libraryNode, JsTreeNode treeNode) {
        libraryNode.accept((RequirementLibraryNodeVisitor)new CustomAttributesPopulator(treeNode));
    }

    @Override
    protected void doAddChildren(JsTreeNode builtNode, RequirementLibraryNode model) {
        NodeContainer container = (NodeContainer)model;
        if (container.hasContent()) {
            RequirementLibraryTreeNodeBuilder childrenBuilder = new RequirementLibraryTreeNodeBuilder(this.permissionEvaluationService);
            childrenBuilder.filterByMilestone(this.milestoneFilter);
            Collection content = container.getOrderedContent();
            List<JsTreeNode> children = new JsTreeNodeListBuilder<RequirementLibraryNode>(childrenBuilder).expand(this.getExpansionCandidates()).setModel(content).build();
            builtNode.setChildren(children);
            JsTreeNode.State state = children.isEmpty() ? JsTreeNode.State.leaf : JsTreeNode.State.open;
            builtNode.setState(state);
        }
    }

    @Override
    protected boolean passesMilestoneFilter() {
        if (this.milestoneFilter != null) {
            return new MilestoneFilter(this.milestoneFilter).isValid((RequirementLibraryNode)this.node);
        }
        return true;
    }

    private class CustomAttributesPopulator
    implements RequirementLibraryNodeVisitor {
        private final JsTreeNode builtNode;

        public CustomAttributesPopulator(JsTreeNode builtNode) {
            this.builtNode = builtNode;
        }

        public void visit(RequirementFolder folder) {
            RequirementLibraryTreeNodeBuilder.this.addFolderAttributes("requirement-folders");
            JsTreeNode.State state = folder.hasContent() ? JsTreeNode.State.closed : JsTreeNode.State.leaf;
            this.builtNode.setState(state);
        }

        public void visit(Requirement requirement) {
            RequirementVersion version;
            RequirementVersion requirementVersion = version = RequirementLibraryTreeNodeBuilder.this.milestoneFilter == null ? requirement.getCurrentVersion() : requirement.findByMilestone(RequirementLibraryTreeNodeBuilder.this.milestoneFilter);
            if (version == null) {
                version = requirement.getCurrentVersion();
                this.builtNode.addAttr("milestones-dont-allow-click", "true");
            }
            this.builtNode.addAttr("name", HtmlUtils.htmlEscape((String)version.getName()));
            this.builtNode.addAttr("reference", HtmlUtils.htmlEscape((String)version.getReference()));
            this.builtNode.setTitle(HtmlUtils.htmlEscape((String)version.getFullName()));
            RequirementLibraryTreeNodeBuilder.this.addLeafAttributes("requirement", "requirements");
            JsTreeNode.State state = requirement.hasContent() ? JsTreeNode.State.closed : JsTreeNode.State.leaf;
            this.builtNode.setState(state);
            String iconName = version.getCategory().getIconName();
            if ("noicon".equals(iconName)) {
                iconName = "def_cat_noicon";
            }
            this.builtNode.addAttr("category-icon", iconName);
            this.builtNode.addAttr("milestones", (Number)RequirementLibraryTreeNodeBuilder.this.totalMilestones(requirement));
            this.builtNode.addAttr("milestone-creatable-deletable", version.doMilestonesAllowCreation().toString());
            this.builtNode.addAttr("milestone-editable", version.doMilestonesAllowEdition().toString());
            if (requirement.isSynchronized()) {
                this.builtNode.addAttr("synchronized", "true");
            }
            if (version.isModifiable()) {
                this.builtNode.addAttr("req-version-modifiable", "true");
            }
        }
    }

    private static final class MilestoneFilter
    implements RequirementLibraryNodeVisitor {
        private Milestone milestone;
        private boolean isValid;

        private MilestoneFilter(Milestone milestone) {
            this.milestone = milestone;
        }

        public boolean isValid(RequirementLibraryNode node) {
            this.isValid = false;
            node.accept((RequirementLibraryNodeVisitor)this);
            return this.isValid;
        }

        public void visit(RequirementFolder folder) {
            this.isValid = true;
        }

        public void visit(Requirement requirement) {
            this.isValid = requirement.meOrMyChildHaveAVersionBoundToMilestone(this.milestone);
        }
    }
}

