/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.squashtest.tm.domain.LevelComparator;
import org.squashtest.tm.web.internal.helper.LevelLabelFormatter;

public class ListJeditableComboDataBuilder<T extends List<?>, B extends ListJeditableComboDataBuilder<T, B>> {
    private Locale locale;
    private List<String> model;
    private LevelComparator modelComparator;
    private LevelLabelFormatter labelFormatter;

    public void setModel(@NotNull List<String> userList) {
        this.model = userList;
    }

    public void setLabelFormatter(LevelLabelFormatter formatter) {
        this.labelFormatter = formatter;
    }

    public void setModel(@NotNull String[] model) {
        this.model = Arrays.asList(model);
    }

    public void setModelComparator(LevelComparator levelComparator) {
        this.modelComparator = levelComparator;
    }

    public Map<String, String> buildMap() {
        return this.createComboData();
    }

    private Map<String, String> createComboData() {
        LinkedHashMap<String, String> comboData = new LinkedHashMap<String, String>(this.model.size());
        this.labelFormatter.useLocale(this.locale);
        for (String item : this.model) {
            comboData.put(item, item);
        }
        return comboData;
    }

    public B useLocale(Locale locale) {
        this.locale = locale;
        return (B)this;
    }
}

