/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.model.builder.GenericJsTreeNodeBuilder;

public abstract class LibraryTreeNodeBuilder<LN extends LibraryNode>
extends GenericJsTreeNodeBuilder<LN, LibraryTreeNodeBuilder<LN>> {
    protected LN node;
    protected JsTreeNode builtNode;

    public LibraryTreeNodeBuilder(PermissionEvaluationService permissionEvaluationService) {
        super(permissionEvaluationService);
    }

    protected abstract void addCustomAttributes(LN var1, JsTreeNode var2);

    protected final void addLeafAttributes(String rel, String resType) {
        this.builtNode.addAttr("rel", rel);
        this.builtNode.addAttr("resType", resType);
        this.builtNode.setState(JsTreeNode.State.leaf);
    }

    protected final void addFolderAttributes(String resType) {
        this.builtNode.addAttr("rel", "folder");
        this.builtNode.addAttr("resType", resType);
        this.builtNode.setState(JsTreeNode.State.closed);
        this.builtNode.addAttr("milestone-creatable-deletable", "true");
        this.builtNode.addAttr("milestone-editable", "true");
    }

    @Override
    public final JsTreeNode doBuild(JsTreeNode builtNode, LN model) {
        this.builtNode = builtNode;
        this.node = model;
        if (this.passesMilestoneFilter()) {
            this.addCommonAttributes();
            this.addCustomAttributes(this.node, builtNode);
        } else {
            this.builtNode = null;
        }
        return this.builtNode;
    }

    protected void addCommonAttributes() {
        String name = HtmlUtils.htmlEscape((String)this.node.getName());
        this.builtNode.setTitle(name);
        this.builtNode.addAttr("name", name);
        this.builtNode.addAttr("resId", String.valueOf(this.node.getId()));
        this.builtNode.addAttr("id", String.valueOf(this.node.getClass().getSimpleName()) + '-' + this.node.getId());
    }

    protected abstract boolean passesMilestoneFilter();

    public final LibraryTreeNodeBuilder<LN> setNode(LN node) {
        if (node == null) {
            throw new NullArgumentException("node");
        }
        this.setModel(node);
        return this;
    }
}

