/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.internal.dto.CustomFieldBindingModel;
import org.squashtest.tm.service.internal.dto.CustomFieldJsonConverter;
import org.squashtest.tm.service.internal.dto.json.JsonInfoList;
import org.squashtest.tm.service.internal.dto.json.JsonMilestone;
import org.squashtest.tm.service.internal.dto.json.JsonProject;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.web.internal.model.builder.JsonInfoListBuilder;

@Component
public class JsonProjectBuilder {
    @Inject
    private CustomFieldBindingFinderService cufBindingService;
    @Inject
    private CustomFieldJsonConverter customFieldConverter;
    @Inject
    private JsonInfoListBuilder infoListBuilder;
    @Inject
    protected ProjectFinder projectFinder;

    public JsonProject toSimpleJson(Project p) {
        return JsonProject.toJson((Project)p);
    }

    public Collection<JsonProject> getExtendedReadableProjects() {
        List projects = this.projectFinder.findAllReadable();
        ArrayList<JsonProject> jsProjects = new ArrayList<JsonProject>(projects.size());
        for (Project p : projects) {
            jsProjects.add(this.toExtendedProject(p));
        }
        return jsProjects;
    }

    public JsonProject toExtendedProject(Project p) {
        JsonProject res = JsonProject.toJson((Project)p);
        JsonInfoList categories = this.infoListBuilder.toJson(p.getRequirementCategories());
        JsonInfoList natures = this.infoListBuilder.toJson(p.getTestCaseNatures());
        JsonInfoList types = this.infoListBuilder.toJson(p.getTestCaseTypes());
        res.setRequirementCategories(categories);
        res.setTestCaseNatures(natures);
        res.setTestCaseTypes(types);
        res.setCustomFieldBindings(this.buildProjectCufBindingsMap(p.getId()));
        List milestones = p.getMilestones();
        HashSet<JsonMilestone> jsmilestones = new HashSet<JsonMilestone>(milestones.size());
        for (Milestone m : milestones) {
            JsonMilestone jsm = new JsonMilestone(m.getId().longValue(), m.getLabel(), m.getStatus(), m.getRange(), m.getEndDate(), m.getOwner().getLogin());
            jsmilestones.add(jsm);
        }
        res.setMilestones(jsmilestones);
        return res;
    }

    public Map<String, List<CustomFieldBindingModel>> buildProjectCufBindingsMap(long projectId) {
        HashMap<String, List<CustomFieldBindingModel>> cufBindings = new HashMap<String, List<CustomFieldBindingModel>>();
        BindableEntity[] bindableEntityArray = BindableEntity.values();
        int n = bindableEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            BindableEntity entity = bindableEntityArray[n2];
            List bindings = this.cufBindingService.findCustomFieldsForProjectAndEntity(projectId, entity);
            ArrayList<CustomFieldBindingModel> jsBindings = new ArrayList<CustomFieldBindingModel>(bindings.size());
            for (CustomFieldBinding binding : bindings) {
                jsBindings.add(this.customFieldConverter.toJson(binding));
            }
            cufBindings.put(entity.toString(), jsBindings);
            ++n2;
        }
        return cufBindings;
    }
}

