/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.util.ArrayList;
import javax.inject.Inject;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.infolist.DenormalizedInfoListItem;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.SystemListItem;
import org.squashtest.tm.service.internal.dto.json.JsonInfoList;
import org.squashtest.tm.service.internal.dto.json.JsonInfoListItem;

@Component
public class JsonInfoListBuilder {
    @Inject
    private MessageSource messageSource;

    public JsonInfoList toJson(InfoList list) {
        JsonInfoList res = new JsonInfoList();
        res.setId(list.getId().longValue());
        res.setCode(HtmlUtils.htmlEscape((String)list.getCode()));
        res.setUri("todo");
        res.setLabel(HtmlUtils.htmlEscape((String)list.getLabel()));
        res.setDescription(HtmlUtils.htmlEscape((String)list.getDescription()));
        ArrayList<JsonInfoListItem> items = new ArrayList<JsonInfoListItem>(list.getItems().size());
        for (InfoListItem item : list.getItems()) {
            JsonInfoListItem jsItem = this.toJson(item);
            items.add(jsItem);
        }
        res.setItems(items);
        return res;
    }

    public JsonInfoListItem toJson(InfoListItem item) {
        JsonInfoListItem res = new JsonInfoListItem();
        res.setId(item.getId().longValue());
        res.setUri("todo");
        res.setCode(HtmlUtils.htmlEscape((String)item.getCode()));
        res.setLabel(HtmlUtils.htmlEscape((String)item.getLabel()));
        res.setDefault(item.isDefault());
        res.setIconName(item.getIconName());
        res.setDenormalized(false);
        res.setSystem(SystemListItem.class.isAssignableFrom(item.getClass()));
        res.setFriendlyLabel(HtmlUtils.htmlEscape((String)this.messageSource.getMessage(res.getLabel(), null, res.getLabel(), LocaleContextHolder.getLocale())));
        return res;
    }

    public JsonInfoListItem toJson(DenormalizedInfoListItem item) {
        JsonInfoListItem res = new JsonInfoListItem();
        res.setCode(item.getCode());
        res.setLabel(item.getLabel());
        res.setIconName(item.getIconName());
        res.setDenormalized(true);
        res.setFriendlyLabel(this.messageSource.getMessage(res.getLabel(), null, res.getLabel(), LocaleContextHolder.getLocale()));
        return res;
    }
}

