/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.report.Report;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.chart.ChartInstance;
import org.squashtest.tm.domain.customreport.CustomReportChartBinding;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportReportBinding;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.chart.ChartModificationService;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.web.internal.controller.chart.JsonChartInstance;
import org.squashtest.tm.web.internal.controller.report.JsonReportInstance;
import org.squashtest.tm.web.internal.helper.ReportHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.i18n.MessageObject;
import org.squashtest.tm.web.internal.model.json.JsonCustomReportChartBinding;
import org.squashtest.tm.web.internal.model.json.JsonCustomReportDashboard;
import org.squashtest.tm.web.internal.model.json.JsonCustomReportReportBinding;
import org.squashtest.tm.web.internal.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.internal.report.ReportsRegistry;

@Component(value="customReport.dashboardBuilder")
@Scope(value="prototype")
public class JsonCustomReportDashboardBuilder {
    private ChartModificationService chartService;
    private JsonCustomReportDashboard json = new JsonCustomReportDashboard();
    private CustomReportDashboard dashboard;
    private InternationalizationHelper i18nHelper;
    private List<EntityReference> scope;
    private String i18nKeyDateFormat = "squashtm.dateformat";
    private boolean isMilestoneDashboard = false;
    private Milestone milestone;
    private Workspace workspace;
    @Inject
    private ReportHelper reportHelper;
    @Inject
    private ReportsRegistry reportsRegistry;

    @Inject
    public JsonCustomReportDashboardBuilder(ChartModificationService chartService, InternationalizationHelper i18nHelper, ActiveMilestoneHolder activeMilestoneHolder) {
        this.chartService = chartService;
        this.i18nHelper = i18nHelper;
        this.milestone = activeMilestoneHolder.getActiveMilestone().orElse(null);
    }

    public JsonCustomReportDashboard build(CustomReportDashboard dashboard, Locale locale) {
        return this.getJsonCustomReportDashboard(dashboard, locale);
    }

    public JsonCustomReportDashboard build(CustomReportDashboard dashboard, Locale locale, List<EntityReference> scope) {
        this.scope = scope;
        return this.getJsonCustomReportDashboard(dashboard, locale);
    }

    public JsonCustomReportDashboard build(CustomReportDashboard dashboard, Locale locale, List<EntityReference> scope, boolean isMilestoneDashboard, Workspace workspace) {
        this.scope = scope;
        this.isMilestoneDashboard = isMilestoneDashboard;
        this.workspace = workspace;
        return this.getJsonCustomReportDashboard(dashboard, locale);
    }

    private JsonCustomReportDashboard getJsonCustomReportDashboard(CustomReportDashboard dashboard, Locale locale) {
        this.dashboard = dashboard;
        this.doBaseAttributes();
        this.doBindings();
        this.doDateAttributes(locale);
        return this.json;
    }

    private void doBindings() {
        Set bindings = this.dashboard.getChartBindings();
        for (CustomReportChartBinding binding : bindings) {
            JsonCustomReportChartBinding jsonBinding = new JsonCustomReportChartBinding();
            jsonBinding.setId(binding.getId());
            jsonBinding.setDashboardId(this.dashboard.getId());
            jsonBinding.setChartDefinitionId(binding.getChart().getId());
            jsonBinding.setRow(binding.getRow());
            jsonBinding.setCol(binding.getCol());
            jsonBinding.setSizeX(binding.getSizeX());
            jsonBinding.setSizeY(binding.getSizeY());
            ChartInstance chartInstance = this.isMilestoneDashboard ? this.chartService.generateChartForMilestoneDashboard(binding.getChart(), this.milestone.getId(), this.workspace) : (this.milestone != null ? this.chartService.generateChartInMilestoneMode(binding.getChart(), this.scope, this.workspace) : this.chartService.generateChart(binding.getChart(), this.scope, this.dashboard.getId()));
            jsonBinding.setChartInstance(new JsonChartInstance(chartInstance));
            this.json.getChartBindings().add(jsonBinding);
        }
        Set reportBindings = this.dashboard.getReportBindings();
        for (CustomReportReportBinding reportBinding : reportBindings) {
            ReportDefinition reportDefinition = reportBinding.getReport();
            Report report = this.reportsRegistry.findReport(reportDefinition.getPluginNamespace());
            JsonCustomReportReportBinding jsonBinding = new JsonCustomReportReportBinding();
            jsonBinding.setId(reportBinding.getId());
            jsonBinding.setDashboardId(this.dashboard.getId());
            jsonBinding.setReportDefinitionId(reportDefinition.getId());
            jsonBinding.setRow(reportBinding.getRow());
            jsonBinding.setCol(reportBinding.getCol());
            jsonBinding.setSizeX(reportBinding.getSizeX());
            jsonBinding.setSizeY(reportBinding.getSizeY());
            JsonReportInstance jsonReportInstance = new JsonReportInstance(reportDefinition);
            jsonReportInstance.setLabel(report.getLabel());
            jsonReportInstance.setReportAttributes(this.reportHelper.getAttributesFromReportDefinition(reportDefinition));
            jsonReportInstance.setDocx(((IdentifiedReportDecorator)report).isDocxTemplate());
            jsonReportInstance.setPdfViews(report.getViews().length);
            jsonBinding.setReportInstance(jsonReportInstance);
            this.json.getReportBindings().add(jsonBinding);
        }
    }

    private void doBaseAttributes() {
        this.json.setId(this.dashboard.getId());
        this.json.setName(this.dashboard.getName());
        CustomReportDashboard audit = this.dashboard;
        this.json.setCreatedBy(audit.getCreatedBy());
        this.json.setLastModifiedBy(audit.getLastModifiedBy());
    }

    private void doDateAttributes(Locale locale) {
        CustomReportDashboard audit = this.dashboard;
        String dateFormat = this.findI18nDateFormat(locale);
        SimpleDateFormat formater = new SimpleDateFormat(dateFormat);
        this.json.setCreatedOn(formater.format(audit.getCreatedOn()));
        if (audit.getLastModifiedBy() != null) {
            this.json.setLastModifiedOn(formater.format(audit.getLastModifiedOn()));
        } else {
            this.json.setLastModifiedOn("");
        }
    }

    private String findI18nDateFormat(Locale locale) {
        MessageObject message = new MessageObject();
        message.put(this.i18nKeyDateFormat, this.i18nKeyDateFormat);
        this.i18nHelper.resolve(message, locale);
        return (String)message.get(this.i18nKeyDateFormat);
    }
}

