/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.persistence.EntityNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.customreport.CustomExportColumnLabel;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportCustomExportColumn;
import org.squashtest.tm.service.customfield.CustomFieldFinderService;
import org.squashtest.tm.service.customreport.CustomReportCustomExportService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.json.JsonCustomReportCustomExport;

@Component(value="customReport.customExportBuilder")
@Scope(value="prototype")
public class JsonCustomExportBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonCustomExportBuilder.class);
    private static final String I18N_KEY_DATE_FORMAT = "squashtm.dateformat";
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private CustomReportCustomExportService customExportService;
    @Inject
    private CustomFieldFinderService cufFinder;

    public JsonCustomReportCustomExport build(CustomReportCustomExport customExport, Locale locale) {
        JsonCustomReportCustomExport jsonCustomExport = new JsonCustomReportCustomExport();
        CustomReportCustomExport auditable = customExport;
        jsonCustomExport.setName(customExport.getName());
        this.fillBasicAttributes((AuditableMixin)auditable, jsonCustomExport, locale);
        this.fillScope(customExport, jsonCustomExport);
        this.fillColumns(customExport, jsonCustomExport, locale);
        return jsonCustomExport;
    }

    private void fillBasicAttributes(AuditableMixin auditable, JsonCustomReportCustomExport jsonCustomExport, Locale locale) {
        jsonCustomExport.setCreatedBy(auditable.getCreatedBy());
        jsonCustomExport.setCreatedOn(this.i18nHelper.localizeDate(auditable.getCreatedOn(), locale));
        jsonCustomExport.setLastModifiedBy(auditable.getLastModifiedBy());
        jsonCustomExport.setLastModifiedOn(this.i18nHelper.localizeDate(auditable.getLastModifiedOn(), locale));
    }

    private void fillScope(CustomReportCustomExport customExport, JsonCustomReportCustomExport jsonCustomExport) {
        ArrayList<String> stringifiedScope = new ArrayList<String>();
        for (EntityReference scopeEntity : customExport.getScope()) {
            String scopeEntityName = this.customExportService.getScopeEntityName(scopeEntity);
            String scope = scopeEntityName.isEmpty() ? this.i18nHelper.internationalize("report.perimeter.not-available-anymore", LocaleContextHolder.getLocale()) : scopeEntityName;
            stringifiedScope.add(scope);
        }
        jsonCustomExport.setScope(stringifiedScope);
    }

    private void fillColumns(CustomReportCustomExport customExport, JsonCustomReportCustomExport jsonCustomExport, Locale locale) {
        LinkedHashMap<EntityType, List<String>> entityTypeToLabelList = new LinkedHashMap<EntityType, List<String>>();
        for (CustomReportCustomExportColumn column : customExport.getColumns()) {
            EntityType entityType = column.getLabel().getEntityType();
            CustomExportColumnLabel label = column.getLabel();
            Long cufId = column.getCufId();
            if (entityTypeToLabelList.get(entityType) == null) {
                entityTypeToLabelList.put(entityType, new ArrayList());
            }
            if (cufId == null) {
                ((List)entityTypeToLabelList.get(entityType)).add(this.i18nHelper.internationalize(label.getI18nKey(), locale));
                continue;
            }
            try {
                ((List)entityTypeToLabelList.get(entityType)).add(this.cufFinder.findById(column.getCufId()).getLabel());
            }
            catch (EntityNotFoundException entityNotFoundException) {
                LOGGER.info("Custom Field of ID " + column.getCufId() + " was deleted and cannot be displayed.");
                ((List)entityTypeToLabelList.get(entityType)).add(this.i18nHelper.internationalize("squashtm.itemdeleted", locale));
            }
        }
        jsonCustomExport.setColumns(entityTypeToLabelList);
    }
}

