/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.model.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.web.internal.model.builder.JsTreeNodeBuilder;

public class JsTreeNodeListBuilder<ITEM extends Identified> {
    private JsTreeNodeBuilder<? super ITEM, ?> nodeBuilder;
    private MultiMap expansionCandidates;
    private Collection<ITEM> model;

    public JsTreeNodeListBuilder(JsTreeNodeBuilder<? super ITEM, ?> nodeBuilder) {
        this.nodeBuilder = nodeBuilder;
    }

    public final JsTreeNodeListBuilder<ITEM> setModel(Collection<ITEM> model) {
        this.model = model;
        return this;
    }

    public final List<JsTreeNode> build() {
        ArrayList<JsTreeNode> nodes = new ArrayList<JsTreeNode>(this.model.size());
        if (this.expansionCandidates == null) {
            this.expansionCandidates = new MultiValueMap();
        }
        int index = 0;
        for (Identified item : this.model) {
            JsTreeNode builtNode = ((JsTreeNodeBuilder)((JsTreeNodeBuilder)((JsTreeNodeBuilder)this.nodeBuilder.setIndex(index)).expand(this.expansionCandidates)).setModel(item)).build();
            if (builtNode == null) continue;
            nodes.add(builtNode);
            ++index;
        }
        return nodes;
    }

    public JsTreeNodeListBuilder<ITEM> expand(MultiMap expansionCandidates) {
        this.expansionCandidates = expansionCandidates;
        return this;
    }

    public JsTreeNodeListBuilder<ITEM> setModel(List<Library<CampaignLibraryNode>> findAllLibraries) {
        this.model = findAllLibraries;
        return this;
    }
}

